/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.write;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.stream.NonBlockingStringWriter;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerSize;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.xml.EXMLVersion;
import com.helger.commons.xml.serialize.write.IXMLWriterSettings;
import com.helger.commons.xml.serialize.write.XMLSerializer;
import com.helger.commons.xml.serialize.write.XMLWriterSettings;
import java.io.OutputStream;
import java.io.Writer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.WillClose;
import javax.annotation.concurrent.Immutable;
import javax.xml.namespace.NamespaceContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;

@Immutable
public final class XMLWriter {
    public static final EXMLVersion DEFAULT_XML_VERSION = EXMLVersion.XML_10;
    public static final NamespaceContext DEFAULT_NAMESPACE_CTX = null;
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLWriter.class);
    private static final IMutableStatisticsHandlerSize s_aSizeHdl = StatisticsManager.getSizeHandler(XMLWriter.class);
    private static final XMLWriter s_aInstance = new XMLWriter();

    private XMLWriter() {
    }

    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream) {
        return XMLWriter.writeToStream(node, outputStream, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToStream(@Nonnull Node node, @Nonnull @WillClose OutputStream outputStream, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(outputStream, "OutputStream");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, outputStream);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            s_aLogger.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            s_aLogger.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close(outputStream);
        }
        return ESuccess.FAILURE;
    }

    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer) {
        return XMLWriter.writeToWriter(node, writer, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public static ESuccess writeToWriter(@Nonnull Node node, @Nonnull @WillClose Writer writer, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        ValueEnforcer.notNull(node, "Node");
        ValueEnforcer.notNull(writer, "Writer");
        ValueEnforcer.notNull(iXMLWriterSettings, "Settings");
        try {
            XMLSerializer xMLSerializer = new XMLSerializer(iXMLWriterSettings);
            xMLSerializer.write(node, writer);
            ESuccess eSuccess = ESuccess.SUCCESS;
            return eSuccess;
        }
        catch (RuntimeException runtimeException) {
            s_aLogger.error("Error in XML serialization", (Throwable)runtimeException);
            throw runtimeException;
        }
        catch (Exception exception) {
            s_aLogger.error("Error in XML serialization", (Throwable)exception);
        }
        finally {
            StreamHelper.close(writer);
        }
        return ESuccess.FAILURE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static String getNodeAsString(@Nonnull Node node, @Nonnull IXMLWriterSettings iXMLWriterSettings) {
        NonBlockingStringWriter nonBlockingStringWriter;
        block4: {
            String string;
            nonBlockingStringWriter = null;
            try {
                nonBlockingStringWriter = new NonBlockingStringWriter(51200);
                if (!XMLWriter.writeToWriter(node, nonBlockingStringWriter, iXMLWriterSettings).isSuccess()) break block4;
                s_aSizeHdl.addSize(nonBlockingStringWriter.getSize());
                string = nonBlockingStringWriter.getAsString();
            }
            catch (Throwable throwable) {
                try {
                    s_aLogger.error("Error serializing DOM node with settings " + iXMLWriterSettings.toString(), throwable);
                }
                catch (Throwable throwable2) {
                    StreamHelper.close(nonBlockingStringWriter);
                    throw throwable2;
                }
                StreamHelper.close(nonBlockingStringWriter);
            }
            StreamHelper.close(nonBlockingStringWriter);
            return string;
        }
        StreamHelper.close(nonBlockingStringWriter);
        return null;
    }

    @Nullable
    public static String getXMLString(@Nonnull Node node) {
        return XMLWriter.getNodeAsString(node, XMLWriterSettings.DEFAULT_XML_SETTINGS);
    }
}

