/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.typeconvert.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class AttributeValueConverter {
    private static final Logger s_aLogger = LoggerFactory.getLogger(AttributeValueConverter.class);

    private AttributeValueConverter() {
    }

    @Nullable
    private static String _getAsSingleString(@Nullable Object object, @Nonnull String[] stringArray, @Nullable String string) {
        s_aLogger.warn("The attribute '" + String.valueOf(object) + "' is an array with " + stringArray.length + " items; using the first one if possible: " + Arrays.toString(stringArray));
        return stringArray.length > 0 ? stringArray[0] : string;
    }

    @Nullable
    public static String getAsString(@Nullable Object object, @Nullable Object object2, @Nullable String string) {
        if (object2 == null) {
            return string;
        }
        if (object2 instanceof String) {
            return (String)object2;
        }
        if (object2 instanceof String[]) {
            return AttributeValueConverter._getAsSingleString(object, (String[])object2, string);
        }
        return TypeConverter.convertIfNecessary(object2, String.class, string);
    }

    public static int getAsInt(@Nullable Object object, @Nullable Object object2, int n) {
        if (object2 == null) {
            return n;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).intValue();
        }
        if (object2 instanceof String[]) {
            return TypeConverter.convertToInt(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), n);
        }
        return TypeConverter.convertToInt(object2, n);
    }

    public static long getAsLong(@Nullable Object object, @Nullable Object object2, long l) {
        if (object2 == null) {
            return l;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).longValue();
        }
        if (object2 instanceof String[]) {
            return TypeConverter.convertToLong(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), l);
        }
        return TypeConverter.convertToLong(object2, l);
    }

    public static double getAsDouble(@Nullable Object object, @Nullable Object object2, double d) {
        if (object2 == null) {
            return d;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).doubleValue();
        }
        if (object2 instanceof String[]) {
            return TypeConverter.convertToDouble(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), d);
        }
        return TypeConverter.convertToDouble(object2, d);
    }

    public static float getAsFloat(@Nullable Object object, @Nullable Object object2, float f) {
        if (object2 == null) {
            return f;
        }
        if (object2 instanceof Number) {
            return ((Number)object2).floatValue();
        }
        if (object2 instanceof String[]) {
            return TypeConverter.convertToFloat(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), f);
        }
        return TypeConverter.convertToFloat(object2, f);
    }

    public static boolean getAsBoolean(@Nullable Object object, @Nullable Object object2, boolean bl) {
        if (object2 == null) {
            return bl;
        }
        if (object2 instanceof Boolean) {
            return (Boolean)object2;
        }
        if (object2 instanceof String[]) {
            return TypeConverter.convertToBoolean(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), bl);
        }
        return TypeConverter.convertToBoolean(object2, bl);
    }

    @Nullable
    public static BigInteger getAsBigInteger(@Nullable Object object, @Nullable Object object2, @Nullable BigInteger bigInteger) {
        if (object2 instanceof String[]) {
            return TypeConverter.convertIfNecessary(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), BigInteger.class, bigInteger);
        }
        return TypeConverter.convertIfNecessary(object2, BigInteger.class, bigInteger);
    }

    @Nullable
    public static BigDecimal getAsBigDecimal(@Nullable Object object, @Nullable Object object2, @Nullable BigDecimal bigDecimal) {
        if (object2 instanceof String[]) {
            return TypeConverter.convertIfNecessary(AttributeValueConverter._getAsSingleString(object, (String[])object2, null), BigDecimal.class, bigDecimal);
        }
        return TypeConverter.convertIfNecessary(object2, BigDecimal.class, bigDecimal);
    }
}

