/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.codec;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.charset.CCharset;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.codec.AbstractByteArrayCodec;
import com.helger.commons.codec.DecodeException;
import com.helger.commons.codec.EncodeException;
import com.helger.commons.string.StringHelper;
import java.nio.charset.Charset;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractRFC1522Codec
extends AbstractByteArrayCodec {
    protected static final char SEP = '?';
    protected static final String PREFIX = "=?";
    protected static final String POSTFIX = "?=";

    @Nonnull
    @Nonempty
    protected abstract String getRFC1522Encoding();

    @Nullable
    protected String getEncodedText(@Nullable String string, @Nonnull Charset charset) throws EncodeException {
        ValueEnforcer.notNull(charset, "SourceCharset");
        if (string == null) {
            return null;
        }
        byte[] byArray = this.getEncoded(CharsetManager.getAsBytes(string, charset));
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(PREFIX).append(charset.name()).append('?').append(this.getRFC1522Encoding()).append('?').append(CharsetManager.getAsString(byArray, CCharset.CHARSET_US_ASCII_OBJ)).append(POSTFIX);
        return stringBuilder.toString();
    }

    @Nullable
    public String getDecodedText(@Nullable String string) throws DecodeException {
        if (string == null) {
            return null;
        }
        ValueEnforcer.isTrue(string.startsWith(PREFIX), "RFC 1522 violation: malformed encoded content. Prefix missing.");
        ValueEnforcer.isTrue(string.endsWith(POSTFIX), "RFC 1522 violation: malformed encoded content. Postfix missing.");
        int n = PREFIX.length();
        int n2 = string.length() - POSTFIX.length();
        int n3 = string.indexOf(63, n);
        if (n3 == n2) {
            throw new DecodeException("RFC 1522 violation: charset token not found");
        }
        String string2 = string.substring(n, n3);
        if (StringHelper.hasNoText(string2)) {
            throw new DecodeException("RFC 1522 violation: charset not specified");
        }
        Charset charset = CharsetManager.getCharsetFromNameOrNull(string2);
        if (charset == null) {
            throw new DecodeException("Failed to resolve charset '" + string2 + "'");
        }
        n = n3 + 1;
        if ((n3 = string.indexOf(63, n)) == n2) {
            throw new DecodeException("RFC 1522 violation: encoding token not found");
        }
        String string3 = string.substring(n, n3);
        if (!this.getRFC1522Encoding().equalsIgnoreCase(string3)) {
            throw new DecodeException("This codec cannot decode '" + string3 + "' encoded content");
        }
        n = n3 + 1;
        n3 = string.indexOf(63, n);
        byte[] byArray = CharsetManager.getAsBytes(string.substring(n, n3), CCharset.CHARSET_US_ASCII_OBJ);
        byte[] byArray2 = this.getDecoded(byArray);
        return CharsetManager.getAsString(byArray2, charset);
    }
}

