/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.file.iterate;

import com.helger.commons.collection.iterate.FilterIterator;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.collection.iterate.IterableIterator;
import com.helger.commons.filter.FilterListAll;
import com.helger.commons.filter.IFilter;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.filter.IFileFilter;
import java.io.File;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public final class FileSystemIterator
extends IterableIterator<File> {
    public FileSystemIterator(@Nonnull String string) {
        this(new File(string));
    }

    public FileSystemIterator(@Nonnull File file) {
        super(FileHelper.getDirectoryContent(file));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, @Nonnull IFileFilter iFileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(string), (IFilter<File>)iFileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, @Nonnull IFileFilter iFileFilter) {
        return new FilterIterator<File>(new FileSystemIterator(file), (IFilter<File>)iFileFilter);
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull String string, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(string), (IFilter<File>)new FilterListAll(iFileFilterArray));
    }

    @Nonnull
    public static IIterableIterator<File> create(@Nonnull File file, IFileFilter ... iFileFilterArray) {
        return new FilterIterator<File>(new FileSystemIterator(file), (IFilter<File>)new FilterListAll(iFileFilterArray));
    }
}

