/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.lang;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.lang.priviledged.PrivilegedActionClassLoaderGetParent;
import com.helger.commons.lang.priviledged.PrivilegedActionGetClassLoader;
import com.helger.commons.lang.priviledged.PrivilegedActionGetContextClassLoader;
import com.helger.commons.lang.priviledged.PrivilegedActionGetSystemClassLoader;
import com.helger.commons.lang.priviledged.PrivilegedActionSetContextClassLoader;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.AccessController;
import java.util.Enumeration;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class ClassLoaderHelper {
    private static final ClassLoaderHelper s_aInstance = new ClassLoaderHelper();

    private ClassLoaderHelper() {
    }

    private static boolean _hasNoSecurityManager() {
        return System.getSecurityManager() == null;
    }

    @Nonnull
    public static ClassLoader getSystemClassLoader() {
        if (ClassLoaderHelper._hasNoSecurityManager()) {
            return ClassLoader.getSystemClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetSystemClassLoader());
    }

    @Nonnull
    public static ClassLoader getContextClassLoader() {
        if (ClassLoaderHelper._hasNoSecurityManager()) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetContextClassLoader());
    }

    public static void setContextClassLoader(ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        if (ClassLoaderHelper._hasNoSecurityManager()) {
            Thread.currentThread().setContextClassLoader(classLoader);
        }
        AccessController.doPrivileged(new PrivilegedActionSetContextClassLoader(classLoader));
    }

    @Nonnull
    public static ClassLoader getClassClassLoader(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "Class");
        if (ClassLoaderHelper._hasNoSecurityManager()) {
            return clazz.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedActionGetClassLoader(clazz));
    }

    @Nonnull
    public static ClassLoader getParentClassLoader(@Nonnull ClassLoader classLoader) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        if (ClassLoaderHelper._hasNoSecurityManager()) {
            return classLoader.getParent();
        }
        return AccessController.doPrivileged(new PrivilegedActionClassLoaderGetParent(classLoader));
    }

    @Nonnull
    public static ClassLoader getDefaultClassLoader() {
        ClassLoader classLoader = null;
        try {
            classLoader = ClassLoaderHelper.getContextClassLoader();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (classLoader == null) {
            classLoader = ClassLoaderHelper.getClassClassLoader(ClassLoaderHelper.class);
        }
        return classLoader;
    }

    @Nonnull
    private static String _getPathWithoutLeadingSlash(@Nonnull @Nonempty String string) {
        return string.charAt(0) == '/' ? string.substring(1) : string;
    }

    @Nullable
    public static URL getResource(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        return classLoader.getResource(string2);
    }

    @Nonnull
    public static Enumeration<URL> getResources(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) throws IOException {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        return classLoader.getResources(string2);
    }

    @Nullable
    public static InputStream getResourceAsStream(@Nonnull ClassLoader classLoader, @Nonnull @Nonempty String string) {
        ValueEnforcer.notNull(classLoader, "ClassLoader");
        ValueEnforcer.notEmpty(string, "Path");
        String string2 = ClassLoaderHelper._getPathWithoutLeadingSlash(string);
        InputStream inputStream = classLoader.getResourceAsStream(string2);
        return StreamHelper.checkForInvalidFilterInputStream(inputStream);
    }
}

