/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.serialize.read;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.io.IHasInputStream;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.pool.IMutableObjectPool;
import com.helger.commons.pool.ObjectPool;
import com.helger.commons.state.ESuccess;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.IMutableStatisticsHandlerTimer;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.xml.sax.InputSourceFactory;
import com.helger.commons.xml.serialize.read.ISAXReaderSettings;
import com.helger.commons.xml.serialize.read.SAXReaderFactory;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

@ThreadSafe
public final class SAXReader {
    private static final IMutableStatisticsHandlerTimer s_aSaxTimerHdl = StatisticsManager.getTimerHandler(SAXReader.class.getName());
    private static final IMutableStatisticsHandlerCounter s_aSaxSuccessCounterHdl = StatisticsManager.getCounterHandler(SAXReader.class.getName() + "$success");
    private static final IMutableStatisticsHandlerCounter s_aSaxErrorCounterHdl = StatisticsManager.getCounterHandler(SAXReader.class.getName() + "$error");
    private static final IMutableObjectPool<XMLReader> s_aSAXPool = new ObjectPool<XMLReader>(5, new SAXReaderFactory());
    private static final SAXReader s_aInstance = new SAXReader();

    private SAXReader() {
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull File file, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(file), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URI uRI, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRI), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull URL uRL, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(uRL), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IHasInputStream iHasInputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iHasInputStream), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull IReadableResource iReadableResource, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(iReadableResource), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull CharSequence charSequence, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(charSequence), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull String string, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(string), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull char[] cArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(cArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byArray, n, n2), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull ByteBuffer byteBuffer, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        return SAXReader.readXMLSAX(InputSourceFactory.create(byteBuffer), iSAXReaderSettings);
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose InputStream inputStream, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull(inputStream, "InputStream");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(inputStream), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close(inputStream);
        }
    }

    @Nonnull
    public static ESuccess readXMLSAX(@Nonnull @WillClose Reader reader, @Nonnull ISAXReaderSettings iSAXReaderSettings) {
        ValueEnforcer.notNull(reader, "Reader");
        try {
            ESuccess eSuccess = SAXReader.readXMLSAX(InputSourceFactory.create(reader), iSAXReaderSettings);
            return eSuccess;
        }
        finally {
            StreamHelper.close(reader);
        }
    }

    /*
     * Exception decompiling
     */
    @Nonnull
    public static ESuccess readXMLSAX(@WillClose @Nonnull InputSource var0, @Nonnull ISAXReaderSettings var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK], 6[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

