/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.aggregate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.string.StringHelper;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@FunctionalInterface
public interface IAggregator<SRCTYPE, DSTTYPE>
extends Function<Collection<SRCTYPE>, DSTTYPE> {
    @Override
    @Nullable
    default public DSTTYPE apply(SRCTYPE ... SRCTYPEArray) {
        return (DSTTYPE)this.apply(CollectionHelper.newList(SRCTYPEArray));
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> IAggregator<SRCTYPE, DSTTYPE> createNull() {
        return collection -> null;
    }

    @Nonnull
    public static <SRCTYPE, DSTTYPE> IAggregator<SRCTYPE, DSTTYPE> createConstant(@Nullable DSTTYPE DSTTYPE) {
        return collection -> DSTTYPE;
    }

    @Nonnull
    public static <SRCTYPE> IAggregator<SRCTYPE, Collection<SRCTYPE>> createUseAll() {
        return collection -> collection;
    }

    @Nonnull
    public static <SRCTYPE> IAggregator<SRCTYPE, SRCTYPE> createUseFirst() {
        return collection -> CollectionHelper.getFirstElement(collection);
    }

    @Nonnull
    public static <SRCTYPE> IAggregator<SRCTYPE, SRCTYPE> createUseLast() {
        return collection -> CollectionHelper.getLastElement(collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringAll() {
        return collection -> StringHelper.getImploded(collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringAll(char c) {
        return collection -> StringHelper.getImploded(c, collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringAll(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Separator");
        return collection -> StringHelper.getImploded(string, collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringIgnoreEmpty() {
        return collection -> StringHelper.getImplodedNonEmpty(collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringIgnoreEmpty(char c) {
        return collection -> StringHelper.getImplodedNonEmpty(c, (Iterable<String>)collection);
    }

    @Nonnull
    public static IAggregator<String, String> createStringIgnoreEmpty(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Separator");
        return collection -> StringHelper.getImplodedNonEmpty(string, (Iterable<String>)collection);
    }
}

