/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.callback;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.callback.ICallback;
import com.helger.commons.callback.ICallbackList;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import com.helger.commons.state.EContinue;
import com.helger.commons.string.ToStringGenerator;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class CallbackList<CALLBACKTYPE extends ICallback>
implements ICallbackList<CALLBACKTYPE>,
ICloneable<CallbackList<CALLBACKTYPE>> {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CallbackList.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<CALLBACKTYPE> m_aCallbacks = new CommonsArrayList<CALLBACKTYPE>();

    public CallbackList() {
    }

    public CallbackList(@Nonnull CallbackList<CALLBACKTYPE> callbackList) {
        ValueEnforcer.notNull(callbackList, "Other");
        this.m_aCallbacks.addAll(callbackList.m_aCallbacks);
    }

    @Nonnull
    public CallbackList<CALLBACKTYPE> addCallback(@Nonnull CALLBACKTYPE CALLBACKTYPE) {
        ValueEnforcer.notNull(CALLBACKTYPE, "Callback");
        this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.add(CALLBACKTYPE));
        return this;
    }

    @Nonnull
    public EChange removeCallback(@Nullable CALLBACKTYPE CALLBACKTYPE) {
        if (CALLBACKTYPE == null) {
            return EChange.UNCHANGED;
        }
        return EChange.valueOf(this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.remove(CALLBACKTYPE)));
    }

    @Nonnull
    public EChange removeAllCallbacks() {
        return this.m_aRWLock.writeLocked(() -> this.m_aCallbacks.removeAll());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<CALLBACKTYPE> getAllCallbacks() {
        return this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aCallbacks.getClone());
    }

    @Override
    @Nullable
    public CALLBACKTYPE getCallbackAtIndex(@Nonnegative int n) {
        return (CALLBACKTYPE)this.m_aRWLock.readLocked(() -> (ICallback)this.m_aCallbacks.getAtIndex(n));
    }

    @Override
    @Nonnegative
    public int getCallbackCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aCallbacks.size());
    }

    @Override
    public boolean hasCallbacks() {
        return this.m_aRWLock.readLocked(() -> this.m_aCallbacks.isNotEmpty());
    }

    @Override
    @Nonnull
    public CallbackList<CALLBACKTYPE> getClone() {
        return this.m_aRWLock.readLocked(() -> new CallbackList<CALLBACKTYPE>(this));
    }

    @Override
    public void forEach(@Nonnull Consumer<CALLBACKTYPE> consumer) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                consumer.accept(iCallback);
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke callback " + iCallback, throwable);
            }
        }
    }

    @Override
    @Nonnull
    public EContinue forEachWithReturn(@Nonnull Function<CALLBACKTYPE, EContinue> function) {
        for (ICallback iCallback : this.getAllCallbacks()) {
            try {
                if (!function.apply(iCallback).isBreak()) continue;
                return EContinue.BREAK;
            }
            catch (Throwable throwable) {
                s_aLogger.error("Failed to invoke callback " + iCallback, throwable);
            }
        }
        return EContinue.CONTINUE;
    }

    public String toString() {
        return new ToStringGenerator(this).append("callbacks", this.m_aCallbacks).toString();
    }
}

