/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ArrayHelper;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsVector;
import com.helger.commons.collection.iterate.IIterableIterator;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class VectorHelper {
    private VectorHelper() {
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nonnegative int n) {
        return new CommonsVector(n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector() {
        return new CommonsVector();
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <SRCTYPE, DSTTYPE> CommonsVector<DSTTYPE> newVectorMapped(@Nullable Collection<? extends SRCTYPE> collection, @Nonnull Function<? super SRCTYPE, DSTTYPE> function) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        for (SRCTYPE SRCTYPE : collection) {
            commonsVector.add(function.apply(SRCTYPE));
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection, @Nonnull Predicate<? super ELEMENTTYPE> predicate) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(collection.size());
        for (ELEMENTTYPE ELEMENTTYPE : collection) {
            if (!predicate.test(ELEMENTTYPE)) continue;
            commonsVector.add(ELEMENTTYPE);
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVectorPrefilled(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnegative int n) {
        ValueEnforcer.isGE0(n, "Elements");
        CommonsVector<int> commonsVector = VectorHelper.newVector(n);
        for (int i = 0; i < n; ++i) {
            commonsVector.add(ELEMENTTYPE);
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        CommonsVector<boolean> commonsVector = VectorHelper.newVector(true);
        commonsVector.add(ELEMENTTYPE);
        return commonsVector;
    }

    @Nonnull
    @SafeVarargs
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ArrayHelper.isEmpty(ELEMENTTYPEArray)) {
            return VectorHelper.newVector(false);
        }
        CommonsVector<int> commonsVector = VectorHelper.newVector(ELEMENTTYPEArray.length);
        Collections.addAll(commonsVector, ELEMENTTYPEArray);
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        CommonsVector<ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                commonsVector.add(enumeration.nextElement());
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        CommonsVector<ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        if (iterator != null) {
            while (iterator.hasNext()) {
                commonsVector.add(iterator.next());
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        CommonsVector<ELEMENTTYPE> commonsVector = VectorHelper.newVector();
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                commonsVector.add(ELEMENTTYPE);
            }
        }
        return commonsVector;
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        if (CollectionHelper.isEmpty(collection)) {
            return VectorHelper.newVector(false);
        }
        return VectorHelper.newVector(collection);
    }

    @Nonnull
    @ReturnsMutableCopy
    public static <ELEMENTTYPE> CommonsVector<ELEMENTTYPE> newVector(@Nullable IIterableIterator<? extends ELEMENTTYPE> iIterableIterator) {
        if (iIterableIterator == null) {
            return VectorHelper.newVector(false);
        }
        return VectorHelper.newVector(iIterableIterator.iterator());
    }
}

