/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.AttributeValueConverter;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.typeconvert.TypeConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IAttributeContainer<KEYTYPE, VALUETYPE>
extends Serializable {
    @Nonnegative
    public int getAttributeCount();

    public boolean isEmpty();

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public boolean containsAttribute(@Nullable KEYTYPE var1);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<KEYTYPE, VALUETYPE> getAllAttributes();

    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE var1);

    @Nullable
    default public <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE) {
        return (DATATYPE)GenericReflection.uncheckedCast(this.getAttributeObject(KEYTYPE));
    }

    @Nullable
    default public <DATATYPE> DATATYPE getCastedAttribute(@Nullable KEYTYPE KEYTYPE, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getCastedAttribute(KEYTYPE);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Nullable
    default public <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz) {
        return TypeConverter.convertIfNecessary(this.getAttributeObject(KEYTYPE), clazz);
    }

    @Nullable
    default public <DATATYPE> DATATYPE getTypedAttribute(@Nullable KEYTYPE KEYTYPE, @Nonnull Class<DATATYPE> clazz, @Nullable DATATYPE DATATYPE) {
        DATATYPE DATATYPE2 = this.getTypedAttribute(KEYTYPE, clazz);
        return DATATYPE2 == null ? DATATYPE : DATATYPE2;
    }

    @Nullable
    default public String getAttributeAsString(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsString(KEYTYPE, null);
    }

    @Nullable
    default public String getAttributeAsString(@Nullable KEYTYPE KEYTYPE, @Nullable String string) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsString(KEYTYPE, VALUETYPE, string);
    }

    default public int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsInt(KEYTYPE, -1);
    }

    default public int getAttributeAsInt(@Nullable KEYTYPE KEYTYPE, int n) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsInt(KEYTYPE, VALUETYPE, n);
    }

    default public long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsLong(KEYTYPE, -1L);
    }

    default public long getAttributeAsLong(@Nullable KEYTYPE KEYTYPE, long l) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsLong(KEYTYPE, VALUETYPE, l);
    }

    default public double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsDouble(KEYTYPE, -1.0);
    }

    default public double getAttributeAsDouble(@Nullable KEYTYPE KEYTYPE, double d) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsDouble(KEYTYPE, VALUETYPE, d);
    }

    default public boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBoolean(KEYTYPE, false);
    }

    default public boolean getAttributeAsBoolean(@Nullable KEYTYPE KEYTYPE, boolean bl) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBoolean(KEYTYPE, VALUETYPE, bl);
    }

    @Nullable
    default public BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigInteger(KEYTYPE, null);
    }

    @Nullable
    default public BigInteger getAttributeAsBigInteger(@Nullable KEYTYPE KEYTYPE, @Nullable BigInteger bigInteger) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBigInteger(KEYTYPE, VALUETYPE, bigInteger);
    }

    @Nullable
    default public BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE) {
        return this.getAttributeAsBigDecimal(KEYTYPE, null);
    }

    @Nullable
    default public BigDecimal getAttributeAsBigDecimal(@Nullable KEYTYPE KEYTYPE, @Nullable BigDecimal bigDecimal) {
        VALUETYPE VALUETYPE = this.getAttributeObject(KEYTYPE);
        return AttributeValueConverter.getAsBigDecimal(KEYTYPE, VALUETYPE, bigDecimal);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<KEYTYPE> getAllAttributeNames();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<VALUETYPE> getAllAttributeValues();

    @Nonnull
    public Iterator<Map.Entry<KEYTYPE, VALUETYPE>> getIterator();
}

