/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.attr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.attr.IAttributeContainer;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class MapBasedReadOnlyAttributeContainer<KEYTYPE, VALUETYPE>
implements IAttributeContainer<KEYTYPE, VALUETYPE> {
    protected final ICommonsMap<KEYTYPE, VALUETYPE> m_aAttrs;

    public MapBasedReadOnlyAttributeContainer(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this(true, new CommonsHashMap());
        this.m_aAttrs.put(KEYTYPE, VALUETYPE);
    }

    public MapBasedReadOnlyAttributeContainer(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        this(true, new CommonsHashMap<KEYTYPE, VALUETYPE>(map));
    }

    public MapBasedReadOnlyAttributeContainer(@Nonnull IAttributeContainer<? extends KEYTYPE, ? extends VALUETYPE> iAttributeContainer) {
        this(true, new CommonsHashMap<KEYTYPE, VALUETYPE>(iAttributeContainer.getAllAttributes()));
    }

    protected MapBasedReadOnlyAttributeContainer(boolean bl, @Nonnull ICommonsMap<KEYTYPE, VALUETYPE> iCommonsMap) {
        this.m_aAttrs = ValueEnforcer.notNull(iCommonsMap, "AttrMap");
    }

    @Override
    @Nonnull
    public Iterator<Map.Entry<KEYTYPE, VALUETYPE>> getIterator() {
        return this.m_aAttrs.entrySet().iterator();
    }

    @Override
    public boolean containsAttribute(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE != null && this.m_aAttrs.containsKey(KEYTYPE);
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<KEYTYPE, VALUETYPE> getAllAttributes() {
        return (ICommonsMap)this.m_aAttrs.getClone();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<KEYTYPE> getAllAttributeNames() {
        return this.m_aAttrs.copyOfKeySet();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsCollection<VALUETYPE> getAllAttributeValues() {
        return this.m_aAttrs.copyOfValues();
    }

    @Override
    @Nullable
    public VALUETYPE getAttributeObject(@Nullable KEYTYPE KEYTYPE) {
        return KEYTYPE == null ? null : (VALUETYPE)this.m_aAttrs.get(KEYTYPE);
    }

    @Override
    @Nonnegative
    public int getAttributeCount() {
        return this.m_aAttrs.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aAttrs.isEmpty();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        MapBasedReadOnlyAttributeContainer mapBasedReadOnlyAttributeContainer = (MapBasedReadOnlyAttributeContainer)object;
        return this.m_aAttrs.equals(mapBasedReadOnlyAttributeContainer.m_aAttrs);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_aAttrs)).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("attrs", this.m_aAttrs).toString();
    }
}

