/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.collection.iterate.IterableIterator;
import com.helger.commons.state.EChange;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsCollection<ELEMENTTYPE>
extends Collection<ELEMENTTYPE>,
Serializable {
    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<ELEMENTTYPE> getCopyAsList() {
        return new CommonsArrayList<ICommonsCollection>(this);
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Collection<? super ELEMENTTYPE> collection) {
        this.findAll(predicate, collection::add);
    }

    default public void findAll(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Consumer<? super ELEMENTTYPE> consumer) {
        CollectionHelper.findAll(this, predicate, consumer);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Collection<? super DSTTYPE> collection) {
        this.findAllMapped(function, collection::add);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> void findAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, function, consumer);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Collection<? super DSTTYPE> collection) {
        this.findAllMapped(predicate, function, collection::add);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> void findAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nonnull Consumer<? super DSTTYPE> consumer) {
        CollectionHelper.findAllMapped(this, predicate, function, consumer);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> void findAllInstanceOf(@Nonnull Class<DSTTYPE> clazz, @Nonnull Consumer<? super DSTTYPE> consumer) {
        this.findAllMapped((? super ELEMENTTYPE object) -> clazz.isInstance(object), (? super ELEMENTTYPE object) -> clazz.cast(object), consumer);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return this.findFirst(predicate, null);
    }

    @Nullable
    default public ELEMENTTYPE findFirst(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.findFirst(this, predicate, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        return this.findFirstMapped(predicate, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE findFirstMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.findFirstMapped(this, predicate, function, DSTTYPE);
    }

    @Nonnegative
    default public int getCount(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.getCount(this, predicate);
    }

    default public boolean containsAny(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsAny(this, predicate);
    }

    default public boolean containsNone(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsNone(this, predicate);
    }

    default public boolean containsOnly(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        return CollectionHelper.containsOnly(this, predicate);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n) {
        return this.getAtIndex(n, null);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.getAtIndex(null, n, ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n) {
        return this.getAtIndex(predicate, n, null);
    }

    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return CollectionHelper.getAtIndex(this, predicate, n, ELEMENTTYPE);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function) {
        return this.getAtIndexMapped(predicate, n, function, null);
    }

    @Nullable
    default public <DSTTYPE> DSTTYPE getAtIndexMapped(@Nonnull Predicate<? super ELEMENTTYPE> predicate, @Nonnegative int n, @Nonnull Function<? super ELEMENTTYPE, ? extends DSTTYPE> function, @Nullable DSTTYPE DSTTYPE) {
        return CollectionHelper.getAtIndexMapped(this, predicate, n, function, DSTTYPE);
    }

    @Nonnull
    default public ICommonsList<ELEMENTTYPE> getSorted(@Nonnull Comparator<? super ELEMENTTYPE> comparator) {
        return CollectionHelper.getSorted(this, comparator);
    }

    default public void addIf(@Nullable ELEMENTTYPE ELEMENTTYPE, @Nonnull Predicate<ELEMENTTYPE> predicate) {
        if (predicate.test(ELEMENTTYPE)) {
            this.add(ELEMENTTYPE);
        }
    }

    default public void addIfNotNull(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        if (ELEMENTTYPE != null) {
            this.add(ELEMENTTYPE);
        }
    }

    default public void addAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        if (ELEMENTTYPEArray != null) {
            for (ELEMENTTYPE ELEMENTTYPE : ELEMENTTYPEArray) {
                this.add(ELEMENTTYPE);
            }
        }
    }

    default public void addAll(@Nullable Enumeration<? extends ELEMENTTYPE> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.add(enumeration.nextElement());
            }
        }
    }

    default public void addAll(@Nullable Iterator<? extends ELEMENTTYPE> iterator) {
        if (iterator != null) {
            while (iterator.hasNext()) {
                this.add(iterator.next());
            }
        }
    }

    default public void addAll(@Nullable Iterable<? extends ELEMENTTYPE> iterable) {
        if (iterable != null) {
            for (ELEMENTTYPE ELEMENTTYPE : iterable) {
                this.add(ELEMENTTYPE);
            }
        }
    }

    default public <SRCTYPE> void addAllMapped(@Nullable Iterable<? extends SRCTYPE> iterable, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        if (iterable != null) {
            for (SRCTYPE SRCTYPE : iterable) {
                this.add(function.apply(SRCTYPE));
            }
        }
    }

    default public <SRCTYPE> void addAllMapped(@Nullable SRCTYPE[] SRCTYPEArray, @Nonnull Function<? super SRCTYPE, ? extends ELEMENTTYPE> function) {
        if (SRCTYPEArray != null) {
            for (SRCTYPE SRCTYPE : SRCTYPEArray) {
                this.add(function.apply(SRCTYPE));
            }
        }
    }

    default public void set(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        this.clear();
        this.add(ELEMENTTYPE);
    }

    default public void setAll(@Nullable Collection<? extends ELEMENTTYPE> collection) {
        this.clear();
        if (collection != null) {
            this.addAll(collection);
        }
    }

    default public void setAll(ELEMENTTYPE ... ELEMENTTYPEArray) {
        this.clear();
        if (ELEMENTTYPEArray != null) {
            this.addAll(ELEMENTTYPEArray);
        }
    }

    @Nonnull
    default public EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    default public Collection<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableCollection(this);
    }

    @Nonnull
    default public IIterableIterator<ELEMENTTYPE> iterator2() {
        return new IterableIterator(this);
    }
}

