/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsList<ELEMENTTYPE>
extends List<ELEMENTTYPE>,
ICommonsCollection<ELEMENTTYPE>,
ICloneable<ICommonsList<ELEMENTTYPE>> {
    @Nonnull
    @ReturnsMutableCopy
    default public <T> ICommonsList<T> createInstance() {
        return new CommonsArrayList();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<ELEMENTTYPE> getAll(@Nullable Predicate<? super ELEMENTTYPE> predicate) {
        if (predicate == null) {
            return (ICommonsList)this.getClone();
        }
        ICommonsList iCommonsList = this.createInstance();
        this.findAll(predicate, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> getAllMapped(@Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(function, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> getAllMapped(@Nullable Predicate<? super ELEMENTTYPE> predicate, @Nonnull Function<? super ELEMENTTYPE, DSTTYPE> function) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllMapped(predicate, function, iCommonsList::add);
        return iCommonsList;
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE extends ELEMENTTYPE> ICommonsList<DSTTYPE> getAllInstanceOf(@Nonnull Class<DSTTYPE> clazz) {
        ICommonsList iCommonsList = this.createInstance();
        this.findAllInstanceOf(clazz, iCommonsList::add);
        return iCommonsList;
    }

    @Override
    @Nullable
    default public ELEMENTTYPE getFirst() {
        return this.isEmpty() ? null : (ELEMENTTYPE)this.get(0);
    }

    @Override
    @Nullable
    default public ELEMENTTYPE getLast() {
        int n = this.size();
        return n == 0 ? null : (ELEMENTTYPE)this.get(n - 1);
    }

    @Override
    @Nullable
    default public ELEMENTTYPE getAtIndex(@Nonnegative int n, @Nullable ELEMENTTYPE ELEMENTTYPE) {
        return (ELEMENTTYPE)(n >= 0 && n < this.size() ? this.get(n) : ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE setFirst(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(0, ELEMENTTYPE);
    }

    @Nullable
    default public ELEMENTTYPE setLast(@Nullable ELEMENTTYPE ELEMENTTYPE) {
        return this.set(this.size() - 1, ELEMENTTYPE);
    }

    @Nonnull
    default public EChange removeAtIndex(int n) {
        if (n < 0 || n >= this.size()) {
            return EChange.UNCHANGED;
        }
        this.remove(n);
        return EChange.CHANGED;
    }

    @Nullable
    default public ELEMENTTYPE removeAndReturnElementAtIndex(int n) {
        return n < 0 || n >= this.size() ? null : (ELEMENTTYPE)this.remove(n);
    }

    @Override
    @Nullable
    default public ELEMENTTYPE removeFirst() {
        return this.isEmpty() ? null : (ELEMENTTYPE)this.remove(0);
    }

    @Override
    @Nullable
    default public ELEMENTTYPE removeLast() {
        int n = this.size();
        return n == 0 ? null : (ELEMENTTYPE)this.remove(n - 1);
    }

    @Override
    @Nonnull
    default public List<ELEMENTTYPE> getAsUnmodifiable() {
        return Collections.unmodifiableList(this);
    }
}

