/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.ext;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.state.EChange;
import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface ICommonsMap<KEYTYPE, VALUETYPE>
extends Map<KEYTYPE, VALUETYPE>,
ICloneable<ICommonsMap<KEYTYPE, VALUETYPE>>,
Serializable {
    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<KEYTYPE> copyOfKeySet() {
        return new CommonsHashSet(this.keySet());
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<VALUETYPE> copyOfValues() {
        return new CommonsArrayList(this.values());
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsList<VALUETYPE> copyOfValues(@Nullable Predicate<? super VALUETYPE> predicate) {
        if (predicate == null) {
            return this.copyOfValues();
        }
        return CollectionHelper.newList(this.values(), predicate);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> copyOfValuesMapped(@Nonnull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        return CollectionHelper.newListMapped(this.values(), function);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public <DSTTYPE> ICommonsList<DSTTYPE> copyOfValuesMapped(@Nullable Predicate<? super VALUETYPE> predicate, @Nonnull Function<? super VALUETYPE, ? extends DSTTYPE> function) {
        if (predicate == null) {
            return this.copyOfValuesMapped(function);
        }
        return CollectionHelper.newListMapped(this.values(), predicate, function);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsSet<Map.Entry<KEYTYPE, VALUETYPE>> copyOfEntrySet() {
        return new CommonsHashSet(this.entrySet());
    }

    default public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    @Nullable
    default public Map.Entry<KEYTYPE, VALUETYPE> getFirstEntry() {
        return this.isEmpty() ? null : this.entrySet().iterator().next();
    }

    @Nullable
    default public KEYTYPE getFirstKey() {
        return this.isEmpty() ? null : (KEYTYPE)this.keySet().iterator().next();
    }

    @Nullable
    default public VALUETYPE getFirstValue() {
        return this.isEmpty() ? null : (VALUETYPE)this.values().iterator().next();
    }

    @Nullable
    default public Map.Entry<KEYTYPE, VALUETYPE> findFirstEntry(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        return CollectionHelper.findFirst(this.entrySet(), predicate);
    }

    @Nullable
    default public KEYTYPE findFirstKey(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (KEYTYPE)entry.getKey();
    }

    @Nullable
    default public VALUETYPE findFirstValue(@Nullable Predicate<? super Map.Entry<KEYTYPE, VALUETYPE>> predicate) {
        Map.Entry<KEYTYPE, VALUETYPE> entry = this.findFirstEntry(predicate);
        return entry == null ? null : (VALUETYPE)entry.getValue();
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsMap<KEYTYPE, VALUETYPE> getSortedByKey(@Nonnull Comparator<? super KEYTYPE> comparator) {
        return CollectionHelper.getSortedByKey(this, comparator);
    }

    @Nonnull
    @ReturnsMutableCopy
    default public ICommonsMap<KEYTYPE, VALUETYPE> getSortedByValue(@Nonnull Comparator<? super VALUETYPE> comparator) {
        return CollectionHelper.getSortedByValue(this, comparator);
    }

    @Nullable
    @ReturnsMutableCopy
    default public ICommonsMap<VALUETYPE, KEYTYPE> getSwappedKeyValues() {
        CommonsHashMap commonsHashMap = new CommonsHashMap();
        for (Map.Entry entry : this.entrySet()) {
            commonsHashMap.put(entry.getValue(), entry.getKey());
        }
        return commonsHashMap;
    }

    @Nonnull
    default public void putIf(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE, @Nonnull Predicate<VALUETYPE> predicate) {
        if (predicate.test(VALUETYPE)) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    @Nonnull
    default public void putIfNotNull(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        if (VALUETYPE != null) {
            this.put(KEYTYPE, VALUETYPE);
        }
    }

    default public void addAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    default public void setAll(@Nullable Map<? extends KEYTYPE, ? extends VALUETYPE> map) {
        this.clear();
        this.addAll(map);
    }

    @Nonnull
    default public EChange removeAll() {
        if (this.isEmpty()) {
            return EChange.UNCHANGED;
        }
        this.clear();
        return EChange.CHANGED;
    }

    @Nonnull
    default public Map<KEYTYPE, VALUETYPE> getAsUnmodifiable() {
        return Collections.unmodifiableMap(this);
    }
}

