/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.impl;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.impl.MapEntry;
import com.helger.commons.lang.GenericReflection;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractSoftMap<K, V>
extends AbstractMap<K, V> {
    protected final Map<K, SoftValue<K, V>> m_aSrcMap;
    private final ReferenceQueue<V> m_aQueue = new ReferenceQueue();

    public AbstractSoftMap(@Nonnull Map<K, SoftValue<K, V>> map) {
        this.m_aSrcMap = ValueEnforcer.notNull(map, "SrcMap");
    }

    @OverrideOnDemand
    protected void onEntryRemoved(K k) {
    }

    @Override
    public V get(Object object) {
        V v = null;
        SoftValue<K, V> softValue = this.m_aSrcMap.get(object);
        if (softValue != null && (v = (V)softValue.get()) == null && this.m_aSrcMap.remove(object) != null) {
            this.onEntryRemoved(GenericReflection.uncheckedCast(object));
        }
        return v;
    }

    private void _processQueue() {
        SoftValue softValue;
        while ((softValue = (SoftValue)GenericReflection.uncheckedCast(this.m_aQueue.poll())) != null) {
            this.m_aSrcMap.remove(softValue.m_aKey);
        }
    }

    @Override
    public V put(K k, V v) {
        this._processQueue();
        SoftValue softValue = this.m_aSrcMap.put(k, new SoftValue(k, v, this.m_aQueue));
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public V remove(Object object) {
        this._processQueue();
        SoftValue<K, V> softValue = this.m_aSrcMap.remove(object);
        return softValue == null ? null : (V)softValue.get();
    }

    @Override
    public void clear() {
        this._processQueue();
        this.m_aSrcMap.clear();
    }

    @Override
    public int size() {
        this._processQueue();
        return this.m_aSrcMap.size();
    }

    @Override
    @ReturnsMutableObject(value="design")
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, SoftValue<K, V>>> set = this.m_aSrcMap.entrySet();
        return new SoftEntrySet(set, this.m_aQueue);
    }

    private static final class SoftEntrySet<K, V>
    implements Set<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, SoftValue<K, V>>> m_aSrcEntrySet;
        private final ReferenceQueue<V> m_aQueue;

        private SoftEntrySet(@Nonnull Set<Map.Entry<K, SoftValue<K, V>>> set, @Nonnull ReferenceQueue<V> referenceQueue) {
            this.m_aSrcEntrySet = set;
            this.m_aQueue = referenceQueue;
        }

        @Override
        public boolean add(@Nonnull Map.Entry<K, V> entry) {
            return this.m_aSrcEntrySet.add(new SoftMapEntry<K, V>(entry.getKey(), entry.getValue(), this.m_aQueue));
        }

        @Override
        public boolean addAll(@Nonnull Collection<? extends Map.Entry<K, V>> collection) {
            boolean bl = false;
            for (Map.Entry<K, V> entry : collection) {
                if (!this.add(entry)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public void clear() {
            this.m_aSrcEntrySet.clear();
        }

        @Override
        public boolean contains(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)GenericReflection.uncheckedCast(object);
            return this.m_aSrcEntrySet.contains(new SoftMapEntry(entry.getKey(), entry.getValue(), this.m_aQueue));
        }

        @Override
        public boolean containsAll(@Nonnull Collection<?> collection) {
            for (Object obj : collection) {
                if (this.contains(obj)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean isEmpty() {
            return this.m_aSrcEntrySet.isEmpty();
        }

        @Override
        @Nonnull
        public Iterator<Map.Entry<K, V>> iterator() {
            Iterator<Map.Entry<K, SoftValue<K, V>>> iterator = this.m_aSrcEntrySet.iterator();
            return new SoftIterator(iterator);
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)GenericReflection.uncheckedCast(object);
            return this.m_aSrcEntrySet.remove(new SoftMapEntry(entry.getKey(), entry.getValue(), this.m_aQueue));
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            boolean bl = false;
            for (Object obj : collection) {
                if (!this.remove(obj)) continue;
                bl = true;
            }
            return bl;
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.m_aSrcEntrySet.size();
        }

        @Override
        @Nonnull
        public Object[] toArray() {
            return this.toArray(new MapEntry[0]);
        }

        @Override
        @Nonnull
        public <T> T[] toArray(@Nullable T[] TArray) {
            MapEntry[] mapEntryArray = null;
            mapEntryArray = TArray != null && TArray instanceof MapEntry[] && TArray.length >= this.size() ? (MapEntry[])GenericReflection.uncheckedCast(TArray) : (MapEntry[])GenericReflection.uncheckedCast(new MapEntry[this.size()]);
            Object[] objectArray = this.m_aSrcEntrySet.toArray();
            for (int i = 0; i < objectArray.length; ++i) {
                Map.Entry entry = (Map.Entry)GenericReflection.uncheckedCast(objectArray[i]);
                mapEntryArray[i] = new MapEntry(entry.getKey(), ((SoftValue)entry.getValue()).get());
            }
            return (Object[])GenericReflection.uncheckedCast(mapEntryArray);
        }

        private static final class SoftIterator<K, V>
        implements Iterator<Map.Entry<K, V>> {
            private final Iterator<Map.Entry<K, SoftValue<K, V>>> m_aSrcIter;

            private SoftIterator(@Nonnull Iterator<Map.Entry<K, SoftValue<K, V>>> iterator) {
                this.m_aSrcIter = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.m_aSrcIter.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                Map.Entry<K, SoftValue<K, V>> entry = this.m_aSrcIter.next();
                return new MapEntry(entry.getKey(), entry.getValue().get());
            }

            @Override
            public void remove() {
                this.m_aSrcIter.remove();
            }
        }
    }

    private static class SoftMapEntry<K, V>
    implements Map.Entry<K, SoftValue<K, V>> {
        private final K m_aKey;
        private SoftValue<K, V> m_aSoftValue;

        public SoftMapEntry(K k, V v, @Nonnull ReferenceQueue<V> referenceQueue) {
            this.m_aKey = k;
            this.m_aSoftValue = new SoftValue(k, v, referenceQueue);
        }

        @Override
        public K getKey() {
            return this.m_aKey;
        }

        @Override
        @Nonnull
        public final SoftValue<K, V> getValue() {
            return this.m_aSoftValue;
        }

        @Override
        public final SoftValue<K, V> setValue(SoftValue<K, V> softValue) {
            SoftValue<K, V> softValue2 = softValue;
            this.m_aSoftValue = softValue;
            return softValue2;
        }
    }

    protected static final class SoftValue<K, V>
    extends SoftReference<V> {
        private final K m_aKey;

        private SoftValue(K k, V v, ReferenceQueue<? super V> referenceQueue) {
            super(v, referenceQueue);
            this.m_aKey = k;
        }
    }
}

