/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.iterate;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.collection.iterate.ArrayIterator;
import com.helger.commons.collection.iterate.EmptyIterator;
import com.helger.commons.collection.iterate.IIterableIterator;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.string.ToStringGenerator;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class IterableIterator<ELEMENTTYPE>
implements IIterableIterator<ELEMENTTYPE> {
    private static final IterableIterator<Object> s_aEmpty = new IterableIterator(new EmptyIterator());
    private final Iterator<ELEMENTTYPE> m_aIter;

    public IterableIterator(@Nonnull ELEMENTTYPE[] ELEMENTTYPEArray) {
        this(new ArrayIterator<ELEMENTTYPE>(ELEMENTTYPEArray).iterator());
    }

    public IterableIterator(@Nonnull Iterable<ELEMENTTYPE> iterable) {
        this(iterable.iterator());
    }

    public IterableIterator(@Nonnull Iterator<ELEMENTTYPE> iterator) {
        this.m_aIter = ValueEnforcer.notNull(iterator, "Iterator");
    }

    @Override
    public final boolean hasNext() {
        return this.m_aIter.hasNext();
    }

    @Override
    @Nullable
    public final ELEMENTTYPE next() {
        return this.m_aIter.next();
    }

    @Override
    public final void remove() {
        this.m_aIter.remove();
    }

    @Override
    @Nonnull
    public final Iterator<ELEMENTTYPE> iterator() {
        return this.m_aIter;
    }

    public String toString() {
        return new ToStringGenerator(this).append("iter", this.m_aIter).toString();
    }

    @Nonnull
    public static <ELEMENTTYPE> IIterableIterator<ELEMENTTYPE> createEmpty() {
        return (IIterableIterator)GenericReflection.uncheckedCast(s_aEmpty);
    }
}

