/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.collection.multimap;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsTreeMap;
import com.helger.commons.collection.multimap.IMultiMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public abstract class AbstractMultiTreeMap<KEYTYPE, VALUETYPE, COLLTYPE extends Collection<VALUETYPE>>
extends CommonsTreeMap<KEYTYPE, COLLTYPE>
implements IMultiMap<KEYTYPE, VALUETYPE, COLLTYPE> {
    public AbstractMultiTreeMap() {
    }

    public AbstractMultiTreeMap(@Nullable Comparator<? super KEYTYPE> comparator) {
        super(comparator);
    }

    public AbstractMultiTreeMap(@Nonnull KEYTYPE KEYTYPE, @Nullable VALUETYPE VALUETYPE) {
        this.putSingle(KEYTYPE, VALUETYPE);
    }

    public AbstractMultiTreeMap(@Nullable KEYTYPE KEYTYPE, @Nullable COLLTYPE COLLTYPE) {
        this.put(KEYTYPE, COLLTYPE);
    }

    public AbstractMultiTreeMap(@Nullable Map<? extends KEYTYPE, ? extends COLLTYPE> map) {
        if (map != null) {
            this.putAll(map);
        }
    }

    @Nonnull
    @ReturnsMutableCopy
    protected abstract COLLTYPE createNewCollection();

    @Override
    @Nonnull
    public COLLTYPE getOrCreate(@Nullable KEYTYPE KEYTYPE) {
        return (COLLTYPE)this.computeIfAbsent(KEYTYPE, object -> this.createNewCollection());
    }
}

