/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.compare;

import com.helger.commons.collation.CollatorHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.text.Collator;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class CompareHelper {
    public static final boolean DEFAULT_NULL_VALUES_COME_FIRST = true;
    private static final CompareHelper s_aInstance = new CompareHelper();

    private CompareHelper() {
    }

    public static int compareTrueBeforeFalse(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? 1 : -1);
    }

    public static int compareFalseBeforeTrue(boolean bl, boolean bl2) {
        return bl == bl2 ? 0 : (bl ? -1 : 1);
    }

    public static int compare(byte by, byte by2) {
        return by < by2 ? -1 : (by == by2 ? 0 : 1);
    }

    public static int compare(char c, char c2) {
        return c < c2 ? -1 : (c == c2 ? 0 : 1);
    }

    public static int compare(double d, double d2) {
        return Double.compare(d, d2);
    }

    public static int compare(float f, float f2) {
        return Float.compare(f, f2);
    }

    public static int compare(int n, int n2) {
        return Integer.compare(n, n2);
    }

    public static int compare(long l, long l2) {
        return Long.compare(l, l2);
    }

    public static int compare(short s, short s2) {
        return s < s2 ? -1 : (s == s2 ? 0 : 1);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2) {
        return CompareHelper.compare(DATATYPE, DATATYPE2, true);
    }

    public static <DATATYPE extends Comparable<? super DATATYPE>> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, boolean bl) {
        if (DATATYPE == DATATYPE2) {
            return 0;
        }
        if (DATATYPE == null) {
            return bl ? -1 : 1;
        }
        if (DATATYPE2 == null) {
            return bl ? 1 : -1;
        }
        return DATATYPE.compareTo(DATATYPE2);
    }

    public static <DATATYPE> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<? super DATATYPE> comparator) {
        return CompareHelper.compare(DATATYPE, DATATYPE2, comparator, true);
    }

    public static <DATATYPE> int compare(@Nullable DATATYPE DATATYPE, @Nullable DATATYPE DATATYPE2, @Nonnull Comparator<? super DATATYPE> comparator, boolean bl) {
        if (DATATYPE == DATATYPE2) {
            return 0;
        }
        if (DATATYPE == null) {
            return bl ? -1 : 1;
        }
        if (DATATYPE2 == null) {
            return bl ? 1 : -1;
        }
        return comparator.compare(DATATYPE, DATATYPE2);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale) {
        return CompareHelper.compare(string, string2, locale, true);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Locale locale, boolean bl) {
        return CompareHelper.compare(string, string2, CollatorHelper.getCollatorSpaceBeforeDot(locale), bl);
    }

    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator) {
        return CompareHelper.compare(string, string2, collator, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int compare(@Nullable String string, @Nullable String string2, @Nonnull Collator collator, boolean bl) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return collator.compare(string, string2);
    }

    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2) {
        return CompareHelper.compareIgnoreCase(string, string2, true);
    }

    @SuppressFBWarnings(value={"ES_COMPARING_PARAMETER_STRING_WITH_EQ"})
    public static int compareIgnoreCase(@Nullable String string, @Nullable String string2, boolean bl) {
        if (string == string2) {
            return 0;
        }
        if (string == null) {
            return bl ? -1 : 1;
        }
        if (string2 == null) {
            return bl ? 1 : -1;
        }
        return string.compareToIgnoreCase(string2);
    }
}

