/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.csv;

import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.string.StringHelper;
import java.io.IOException;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class CSVParser {
    private char m_cSeparatorChar = (char)44;
    private char m_cQuoteChar = (char)34;
    private char m_cEscapeChar = (char)92;
    private boolean m_bStrictQuotes = false;
    private boolean m_bIgnoreLeadingWhiteSpace = true;
    private boolean m_bIgnoreQuotations = false;
    private String m_sPending;
    private boolean m_bInField = false;

    public char getSeparatorChar() {
        return this.m_cSeparatorChar;
    }

    @Nonnull
    public CSVParser setSeparatorChar(char c) {
        if (c == '\u0000') {
            throw new UnsupportedOperationException("The separator character must be defined!");
        }
        this.m_cSeparatorChar = c;
        if (this._anyCharactersAreTheSame()) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        return this;
    }

    public char getQuoteChar() {
        return this.m_cQuoteChar;
    }

    @Nonnull
    public CSVParser setQuoteChar(char c) {
        this.m_cQuoteChar = c;
        if (this._anyCharactersAreTheSame()) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        return this;
    }

    public char getEscapeChar() {
        return this.m_cEscapeChar;
    }

    @Nonnull
    public CSVParser setEscapeChar(char c) {
        this.m_cEscapeChar = c;
        if (this._anyCharactersAreTheSame()) {
            throw new UnsupportedOperationException("The separator, quote, and escape characters must be different!");
        }
        return this;
    }

    public boolean isStrictQuotes() {
        return this.m_bStrictQuotes;
    }

    @Nonnull
    public CSVParser setStrictQuotes(boolean bl) {
        this.m_bStrictQuotes = bl;
        return this;
    }

    public boolean isIgnoreLeadingWhiteSpace() {
        return this.m_bIgnoreLeadingWhiteSpace;
    }

    @Nonnull
    public CSVParser setIgnoreLeadingWhiteSpace(boolean bl) {
        this.m_bIgnoreLeadingWhiteSpace = bl;
        return this;
    }

    public boolean isIgnoreQuotations() {
        return this.m_bIgnoreQuotations;
    }

    @Nonnull
    public CSVParser setIgnoreQuotations(boolean bl) {
        this.m_bIgnoreQuotations = bl;
        return this;
    }

    private boolean _anyCharactersAreTheSame() {
        return CSVParser._isSameCharacter(this.m_cSeparatorChar, this.m_cQuoteChar) || CSVParser._isSameCharacter(this.m_cSeparatorChar, this.m_cEscapeChar) || CSVParser._isSameCharacter(this.m_cQuoteChar, this.m_cEscapeChar);
    }

    private static boolean _isSameCharacter(char c, char c2) {
        return c != '\u0000' && c == c2;
    }

    public boolean isPending() {
        return this.m_sPending != null;
    }

    @Nullable
    public ICommonsList<String> parseLineMulti(@Nullable String string) throws IOException {
        return this._parseLine(string, true);
    }

    @Nullable
    public ICommonsList<String> parseLine(@Nullable String string) throws IOException {
        return this._parseLine(string, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private ICommonsList<String> _parseLine(@Nullable String string, boolean bl) throws IOException {
        if (!bl && this.m_sPending != null) {
            this.m_sPending = null;
        }
        if (string == null) {
            if (this.m_sPending == null) return null;
            String string2 = this.m_sPending;
            this.m_sPending = null;
            return CollectionHelper.newList(string2);
        }
        CommonsArrayList<String> commonsArrayList = new CommonsArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder(128);
        boolean bl2 = false;
        if (this.m_sPending != null) {
            stringBuilder.append(this.m_sPending);
            this.m_sPending = null;
            bl2 = !this.m_bIgnoreQuotations;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c == this.m_cEscapeChar) {
                if (!this.isNextCharacterEscapable(string, this._isInQuotes(bl2), i)) continue;
                i = this._appendNextCharacterAndAdvanceLoop(string, stringBuilder, i);
                continue;
            }
            if (c == this.m_cQuoteChar) {
                if (this._isNextCharacterEscapedQuote(string, this._isInQuotes(bl2), i)) {
                    i = this._appendNextCharacterAndAdvanceLoop(string, stringBuilder, i);
                } else {
                    boolean bl3 = bl2 = !bl2;
                    if (!this.m_bStrictQuotes && i > 2 && string.charAt(i - 1) != this.m_cSeparatorChar && string.length() > i + 1 && string.charAt(i + 1) != this.m_cSeparatorChar) {
                        if (this.m_bIgnoreLeadingWhiteSpace && stringBuilder.length() > 0 && this.isAllWhiteSpace(stringBuilder)) {
                            stringBuilder.setLength(0);
                        } else {
                            stringBuilder.append(c);
                        }
                    }
                }
                this.m_bInField = !this.m_bInField;
                continue;
            }
            if (c == this.m_cSeparatorChar && (!bl2 || this.m_bIgnoreQuotations)) {
                commonsArrayList.add(stringBuilder.toString());
                stringBuilder.setLength(0);
                this.m_bInField = false;
                continue;
            }
            if (this.m_bStrictQuotes && (!bl2 || this.m_bIgnoreQuotations)) continue;
            stringBuilder.append(c);
            this.m_bInField = true;
        }
        if (bl2 && !this.m_bIgnoreQuotations) {
            if (!bl) throw new IOException("Un-terminated quoted field at end of CSV line");
            stringBuilder.append('\n');
            this.m_sPending = stringBuilder.toString();
            stringBuilder = null;
        } else {
            this.m_bInField = false;
        }
        if (stringBuilder == null) return commonsArrayList;
        commonsArrayList.add(stringBuilder.toString());
        return commonsArrayList;
    }

    @Nonnegative
    private int _appendNextCharacterAndAdvanceLoop(@Nonnull String string, @Nonnull StringBuilder stringBuilder, @Nonnegative int n) {
        stringBuilder.append(string.charAt(n + 1));
        return n + 1;
    }

    private boolean _isInQuotes(boolean bl) {
        return bl && !this.m_bIgnoreQuotations || this.m_bInField;
    }

    private boolean _isNextCharacterEscapedQuote(@Nonnull String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && this._isCharacterQuoteCharacter(string.charAt(n + 1));
    }

    private boolean _isCharacterQuoteCharacter(char c) {
        return c == this.m_cQuoteChar;
    }

    private boolean _isCharacterEscapeCharacter(char c) {
        return c == this.m_cEscapeChar;
    }

    private boolean _isCharacterEscapable(char c) {
        return this._isCharacterQuoteCharacter(c) || this._isCharacterEscapeCharacter(c);
    }

    protected boolean isNextCharacterEscapable(@Nonnull String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && this._isCharacterEscapable(string.charAt(n + 1));
    }

    protected boolean isAllWhiteSpace(@Nonnull CharSequence charSequence) {
        return StringHelper.isAllWhitespace(charSequence);
    }
}

