/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.datetime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.ResolverStyle;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
@DevelopersNote(value="The mutable m_aHashCode does not contradict thread safety")
public final class DateTimeFormatterPattern {
    private final String m_sPattern;
    private final ResolverStyle m_eResolverStyle;
    private final DateTimeFormatter m_aFormatter;
    private Integer m_aHashCode;

    public DateTimeFormatterPattern(@Nonnull @Nonempty String string, @Nonnull ResolverStyle resolverStyle) throws IllegalArgumentException {
        ValueEnforcer.notEmpty(string, "RegEx");
        ValueEnforcer.notNull(resolverStyle, "ResolverStyle");
        this.m_sPattern = string;
        this.m_eResolverStyle = resolverStyle;
        this.m_aFormatter = new DateTimeFormatterBuilder().appendPattern(string).toFormatter().withResolverStyle(this.m_eResolverStyle);
    }

    @Nonnull
    @Nonempty
    public String getPattern() {
        return this.m_sPattern;
    }

    @Nonnull
    public ResolverStyle getResolverStyle() {
        return this.m_eResolverStyle;
    }

    @Nonnull
    public DateTimeFormatter getAsFormatter() {
        return this.m_aFormatter;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        DateTimeFormatterPattern dateTimeFormatterPattern = (DateTimeFormatterPattern)object;
        return this.m_sPattern.equals(dateTimeFormatterPattern.m_sPattern) && this.m_eResolverStyle.equals((Object)dateTimeFormatterPattern.m_eResolverStyle);
    }

    public int hashCode() {
        if (this.m_aHashCode == null) {
            this.m_aHashCode = ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPattern).append((Enum)this.m_eResolverStyle)).getHashCodeObj();
        }
        return this.m_aHashCode;
    }

    public String toString() {
        return new ToStringGenerator(this).append("Pattern", this.m_sPattern).append("ResolverStyle", this.m_eResolverStyle).toString();
    }
}

