/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.errorlist;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.error.IHasErrorID;
import com.helger.commons.error.IResourceLocation;
import com.helger.commons.error.ResourceLocation;
import com.helger.commons.errorlist.IErrorBase;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IError
extends IHasErrorID,
IErrorBase<IError> {
    @Nullable
    public String getErrorFieldName();

    default public boolean hasErrorFieldName() {
        return StringHelper.hasText(this.getErrorFieldName());
    }

    default public boolean hasNoErrorFieldName() {
        return StringHelper.hasNoText(this.getErrorFieldName());
    }

    default public boolean hasErrorFieldName(@Nullable String string) {
        return EqualsHelper.equals(this.getErrorFieldName(), string);
    }

    @Nullable
    default public IResourceLocation getResourceLocation() {
        if (this.hasErrorFieldName()) {
            return new ResourceLocation(null, this.getErrorFieldName());
        }
        return null;
    }

    @Nonnull
    @Nonempty
    public String getErrorText();
}

