/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.filter;

import java.io.Serializable;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nonnull;

@FunctionalInterface
public interface IFilter<DATATYPE>
extends Serializable,
Predicate<DATATYPE> {
    @Override
    @Nonnull
    default public IFilter<DATATYPE> and(@Nonnull IFilter<? super DATATYPE> iFilter) {
        Objects.requireNonNull(iFilter);
        return object -> this.test(object) && iFilter.test(object);
    }

    @Override
    @Nonnull
    default public IFilter<DATATYPE> or(@Nonnull IFilter<? super DATATYPE> iFilter) {
        Objects.requireNonNull(iFilter);
        return object -> this.test(object) || iFilter.test(object);
    }

    @Override
    @Nonnull
    default public IFilter<DATATYPE> negate() {
        return object -> !this.test(object);
    }

    @Nonnull
    public static <DATATYPE> IFilter<DATATYPE> all() {
        return object -> true;
    }

    @Nonnull
    public static <DATATYPE> IFilter<DATATYPE> none() {
        return object -> false;
    }

    @Nonnull
    public static <DATATYPE> IFilter<DATATYPE> notNull() {
        return object -> object != null;
    }

    @Nonnull
    public static <DATATYPE> IFilter<DATATYPE> isNull() {
        return object -> object == null;
    }
}

