/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.IIntIDFactory;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractPersistingIntIDFactory
implements IIntIDFactory {
    private final SimpleLock m_aLock = new SimpleLock();
    private final int m_nReserveCount;
    private int m_nID = 0;
    private int m_nLastID = -1;

    public AbstractPersistingIntIDFactory(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "ReserveCount");
        this.m_nReserveCount = n;
    }

    @Nonnegative
    public final int getReserveCount() {
        return this.m_nReserveCount;
    }

    protected abstract int readAndUpdateIDCounter(@Nonnegative int var1);

    @Override
    public final int getNewID() {
        return this.m_aLock.locked(() -> {
            if (this.m_nID >= this.m_nLastID) {
                int n = this.readAndUpdateIDCounter(this.m_nReserveCount);
                if (this.m_nLastID >= 0 && n < this.m_nID) {
                    throw new IllegalStateException("The read value " + n + " is smaller than the last known ID " + this.m_nID + "!");
                }
                this.m_nID = n;
                this.m_nLastID = n + this.m_nReserveCount;
            }
            return this.m_nID++;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractPersistingIntIDFactory abstractPersistingIntIDFactory = (AbstractPersistingIntIDFactory)object;
        return this.m_nReserveCount == abstractPersistingIntIDFactory.m_nReserveCount && this.m_nID == abstractPersistingIntIDFactory.m_nID;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nReserveCount).append(this.m_nID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("reserveCount", this.m_nReserveCount).append("ID", this.m_nID).append("lastID", this.m_nLastID).toString();
    }
}

