/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.concurrent.SimpleLock;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.ILongIDFactory;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnegative;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class AbstractPersistingLongIDFactory
implements ILongIDFactory {
    private final SimpleLock m_aLock = new SimpleLock();
    private final int m_nReserveCount;
    private long m_nID = 0L;
    private long m_nLastID = -1L;

    public AbstractPersistingLongIDFactory(@Nonnegative int n) {
        ValueEnforcer.isGT0(n, "ReserveCount");
        this.m_nReserveCount = n;
    }

    @Nonnegative
    protected final int getReserveCount() {
        return this.m_nReserveCount;
    }

    protected abstract long readAndUpdateIDCounter(@Nonnegative int var1);

    @Override
    public final long getNewID() {
        return this.m_aLock.locked(() -> {
            if (this.m_nID >= this.m_nLastID) {
                long l = this.readAndUpdateIDCounter(this.m_nReserveCount);
                if (this.m_nLastID >= 0L && l < this.m_nID) {
                    throw new IllegalStateException("The read value " + l + " is smaller than the last known ID " + this.m_nID + "!");
                }
                this.m_nID = l;
                this.m_nLastID = l + (long)this.m_nReserveCount;
            }
            return this.m_nID++;
        });
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        AbstractPersistingLongIDFactory abstractPersistingLongIDFactory = (AbstractPersistingLongIDFactory)object;
        return this.m_nReserveCount == abstractPersistingLongIDFactory.m_nReserveCount && this.m_nID == abstractPersistingLongIDFactory.m_nID;
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_nReserveCount).append(this.m_nID).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("reserveCount", this.m_nReserveCount).append("ID", this.m_nID).append("lastID", this.m_nLastID).toString();
    }
}

