/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.id.factory;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.id.factory.IStringIDFactory;
import com.helger.commons.string.ToStringGenerator;
import javax.annotation.Nonnull;

public class StringIDFactory
implements IStringIDFactory {
    private final String m_sPrefix;
    private final IStringIDFactory m_aBaseFactory;

    public StringIDFactory(@Nonnull IStringIDFactory iStringIDFactory) {
        this("id", iStringIDFactory);
    }

    public StringIDFactory(@Nonnull String string, @Nonnull IStringIDFactory iStringIDFactory) {
        this.m_sPrefix = ValueEnforcer.notNull(string, "Prefix");
        this.m_aBaseFactory = ValueEnforcer.notNull(iStringIDFactory, "BaseFactory");
    }

    @Nonnull
    public String getPrefix() {
        return this.m_sPrefix;
    }

    @Override
    @Nonnull
    public String getNewID() {
        return this.m_sPrefix + (String)this.m_aBaseFactory.getNewID();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        StringIDFactory stringIDFactory = (StringIDFactory)object;
        return this.m_sPrefix.equals(stringIDFactory.m_sPrefix) && this.m_aBaseFactory.equals(stringIDFactory.m_aBaseFactory);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_sPrefix).append(this.m_aBaseFactory).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).append("BaseFactory", this.m_aBaseFactory).toString();
    }
}

