/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.io.stream;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.io.stream.WrappedOutputStream;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class MessageDigestOutputStream
extends WrappedOutputStream {
    private final IMessageDigestGenerator m_aMDGen;

    public MessageDigestOutputStream(@Nonnull OutputStream outputStream, @Nonnull EMessageDigestAlgorithm eMessageDigestAlgorithm) {
        this(outputStream, new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithm));
    }

    public MessageDigestOutputStream(@Nonnull OutputStream outputStream, @Nonnull IMessageDigestGenerator iMessageDigestGenerator) {
        super(outputStream);
        this.m_aMDGen = ValueEnforcer.notNull(iMessageDigestGenerator, "MDGen");
    }

    @Override
    public void write(int n) throws IOException {
        super.write(n);
        this.m_aMDGen.update((byte)n);
    }

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getDigest() {
        return this.m_aMDGen.getAllDigestBytes();
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("mdgen", this.m_aMDGen).toString();
    }
}

