/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.log;

import com.helger.commons.annotation.OverrideOnDemand;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.error.EErrorLevel;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasErrorLevels;
import com.helger.commons.lang.IHasSize;
import com.helger.commons.log.LogMessage;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IClearable;
import com.helger.commons.string.ToStringGenerator;
import java.io.Serializable;
import java.util.Iterator;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InMemoryLogger
implements Iterable<LogMessage>,
IHasSize,
IClearable,
IHasErrorLevels,
Serializable {
    private final ICommonsList<LogMessage> m_aMessages = new CommonsArrayList<LogMessage>();

    @Nullable
    @OverrideOnDemand
    protected LogMessage createLogMessage(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        return new LogMessage(iErrorLevel, serializable, throwable);
    }

    @OverrideOnDemand
    protected void onAddLogMessage(@Nonnull LogMessage logMessage) {
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable) {
        this.log(iErrorLevel, serializable, null);
    }

    public void log(@Nonnull IErrorLevel iErrorLevel, @Nonnull Serializable serializable, @Nullable Throwable throwable) {
        LogMessage logMessage = this.createLogMessage(iErrorLevel, serializable, throwable);
        if (logMessage != null) {
            this.m_aMessages.add(logMessage);
            this.onAddLogMessage(logMessage);
        }
    }

    public void error(@Nonnull Serializable serializable) {
        this.error(serializable, null);
    }

    public void error(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.ERROR, serializable, throwable);
    }

    public void warn(@Nonnull Serializable serializable) {
        this.warn(serializable, null);
    }

    public void warn(@Nonnull Serializable serializable, @Nullable Throwable throwable) {
        this.log(EErrorLevel.WARN, serializable, throwable);
    }

    public void info(@Nonnull Serializable serializable) {
        this.log(EErrorLevel.INFO, serializable, null);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<LogMessage> getAllMessages() {
        return (ICommonsList)this.m_aMessages.getClone();
    }

    @Override
    @Nonnull
    public Iterator<LogMessage> iterator() {
        return this.m_aMessages.iterator();
    }

    @Override
    @Nonnegative
    public int getSize() {
        return this.m_aMessages.size();
    }

    @Override
    public boolean isEmpty() {
        return this.m_aMessages.isEmpty();
    }

    @Override
    public boolean containsOnlySuccess() {
        return this.m_aMessages.containsOnly(logMessage -> logMessage.isSuccess());
    }

    @Override
    public boolean containsAtLeastOneSuccess() {
        return this.m_aMessages.containsAny(logMessage -> logMessage.isSuccess());
    }

    @Override
    public boolean containsNoSuccess() {
        return this.m_aMessages.containsNone(logMessage -> logMessage.isSuccess());
    }

    @Override
    @Nonnegative
    public int getSuccessCount() {
        return this.m_aMessages.getCount(logMessage -> logMessage.isSuccess());
    }

    @Override
    public boolean containsOnlyFailure() {
        return this.m_aMessages.containsOnly(logMessage -> logMessage.isFailure());
    }

    @Override
    public boolean containsAtLeastOneFailure() {
        return this.m_aMessages.containsAny(logMessage -> logMessage.isFailure());
    }

    @Override
    public boolean containsNoFailure() {
        return this.m_aMessages.containsNone(logMessage -> logMessage.isFailure());
    }

    @Override
    @Nonnegative
    public int getFailureCount() {
        return this.m_aMessages.getCount(logMessage -> logMessage.isFailure());
    }

    @Override
    public boolean containsOnlyError() {
        return this.m_aMessages.containsOnly(logMessage -> logMessage.isError());
    }

    @Override
    public boolean containsAtLeastOneError() {
        return this.m_aMessages.containsAny(logMessage -> logMessage.isError());
    }

    @Override
    public boolean containsNoError() {
        return this.m_aMessages.containsNone(logMessage -> logMessage.isError());
    }

    @Override
    @Nonnegative
    public int getErrorCount() {
        return this.m_aMessages.getCount(logMessage -> logMessage.isError());
    }

    @Override
    @Nonnull
    public IErrorLevel getMostSevereErrorLevel() {
        LogMessage logMessage;
        IErrorLevel iErrorLevel;
        IErrorLevel iErrorLevel2 = EErrorLevel.SUCCESS;
        Iterator iterator = this.m_aMessages.iterator();
        while (!(!iterator.hasNext() || (iErrorLevel = (logMessage = (LogMessage)iterator.next()).getErrorLevel()).isMoreSevereThan(iErrorLevel2) && (iErrorLevel2 = iErrorLevel).isHighest())) {
        }
        return iErrorLevel2;
    }

    @Override
    @Nonnull
    public EChange clear() {
        return this.m_aMessages.removeAll();
    }

    public String toString() {
        return new ToStringGenerator(this).append("messages", this.m_aMessages).toString();
    }
}

