/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.charset.CharsetManager;
import com.helger.commons.messagedigest.MessageDigestGeneratorHelper;
import java.nio.charset.Charset;
import java.security.Provider;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;

public interface IMessageDigestGenerator {
    @Nonnull
    public Provider getSecurityProvider();

    @Nonnull
    public String getAlgorithmName();

    @Nonnegative
    public int getDigestLength();

    @Nonnull
    public IMessageDigestGenerator update(byte var1);

    @Nonnull
    default public IMessageDigestGenerator update(@Nonnull String string, @Nonnull Charset charset) {
        ValueEnforcer.notNull(string, "Value");
        ValueEnforcer.notNull(charset, "Charset");
        return this.update(CharsetManager.getAsBytes(string, charset));
    }

    @Nonnull
    default public IMessageDigestGenerator update(@Nonnull byte[] byArray) {
        ValueEnforcer.notNull(byArray, "Value");
        return this.update(byArray, 0, byArray.length);
    }

    @Nonnull
    public IMessageDigestGenerator update(@Nonnull byte[] var1, @Nonnegative int var2, @Nonnegative int var3);

    public void reset();

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes();

    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes(@Nonnegative int var1);

    default public long getDigestLong() {
        return MessageDigestGeneratorHelper.getLongFromDigest(this.getAllDigestBytes());
    }

    @Nonnull
    default public String getDigestHexString() {
        return MessageDigestGeneratorHelper.getHexValueFromDigest(this.getAllDigestBytes());
    }
}

