/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.messagedigest;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.messagedigest.EMessageDigestAlgorithm;
import com.helger.commons.messagedigest.IMessageDigestGenerator;
import com.helger.commons.messagedigest.NonBlockingMessageDigestGenerator;
import com.helger.commons.string.ToStringGenerator;
import java.security.Provider;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class MessageDigestGenerator
implements IMessageDigestGenerator {
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    private final IMessageDigestGenerator m_aMDGen;

    public MessageDigestGenerator() {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator();
    }

    public MessageDigestGenerator(@Nullable String string) {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(string);
    }

    public MessageDigestGenerator(EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(eMessageDigestAlgorithmArray);
    }

    public MessageDigestGenerator(@Nullable String string, EMessageDigestAlgorithm ... eMessageDigestAlgorithmArray) {
        this.m_aMDGen = new NonBlockingMessageDigestGenerator(string, eMessageDigestAlgorithmArray);
    }

    @Override
    @Nonnull
    public Provider getSecurityProvider() {
        return this.m_aMDGen.getSecurityProvider();
    }

    @Override
    @Nonnull
    public String getAlgorithmName() {
        return this.m_aMDGen.getAlgorithmName();
    }

    @Override
    @Nonnegative
    public int getDigestLength() {
        return this.m_aMDGen.getDigestLength();
    }

    @Override
    @Nonnull
    public MessageDigestGenerator update(byte by) {
        this.m_aRWLock.writeLocked(() -> this.m_aMDGen.update(by));
        return this;
    }

    @Override
    @Nonnull
    public MessageDigestGenerator update(@Nonnull byte[] byArray, @Nonnegative int n, @Nonnegative int n2) {
        this.m_aRWLock.writeLocked(() -> this.m_aMDGen.update(byArray, n, n2));
        return this;
    }

    @Override
    public void reset() {
        this.m_aRWLock.writeLocked(() -> this.m_aMDGen.reset());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes() {
        return this.m_aRWLock.writeLocked(() -> this.m_aMDGen.getAllDigestBytes());
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public byte[] getAllDigestBytes(@Nonnegative int n) {
        return this.m_aRWLock.writeLocked(() -> this.m_aMDGen.getAllDigestBytes(n));
    }

    public String toString() {
        return new ToStringGenerator(this).append("MessageDigestGenerator", this.m_aMDGen).toString();
    }
}

