/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.microdom.AbstractMicroNode;
import com.helger.commons.microdom.EMicroEvent;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroCDATA;
import com.helger.commons.microdom.IMicroNode;
import com.helger.commons.microdom.IMicroNodeWithChildren;
import com.helger.commons.microdom.IMicroText;
import com.helger.commons.microdom.MicroException;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.TypeConverter;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.OverridingMethodsMustInvokeSuper;

public abstract class AbstractMicroNodeWithChildren
extends AbstractMicroNode
implements IMicroNodeWithChildren {
    private ICommonsList<IMicroNode> m_aChildren;

    @Nullable
    @ReturnsMutableObject(value="efficient access")
    final ICommonsList<IMicroNode> directGetAllChildren() {
        return this.m_aChildren;
    }

    private void _afterInsertAsChildOfThis(@Nonnull AbstractMicroNode abstractMicroNode) {
        abstractMicroNode.setParentNode(this);
        this.onEvent(EMicroEvent.NODE_INSERTED, this, abstractMicroNode);
    }

    @Override
    protected void onAppendChild(@Nonnull AbstractMicroNode abstractMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to documents");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new CommonsArrayList<IMicroNode>();
        }
        this.m_aChildren.add(abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertBefore(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf(iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add before element which is not contained!");
        }
        this.m_aChildren.add(n, abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAfter(@Nonnull AbstractMicroNode abstractMicroNode, @Nonnull IMicroNode iMicroNode) {
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (iMicroNode == null || this.m_aChildren == null) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        int n = this.m_aChildren.lastIndexOf(iMicroNode);
        if (n == -1) {
            throw new MicroException("Cannot add after element which is not contained!");
        }
        this.m_aChildren.add(n + 1, abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    @Override
    protected final void onInsertAtIndex(@Nonnegative int n, @Nonnull AbstractMicroNode abstractMicroNode) {
        if (n < 0) {
            throw new MicroException("Cannot insert element at index " + n + "!");
        }
        if (abstractMicroNode.isDocument()) {
            throw new MicroException("Cannot add document to nodes");
        }
        if (this.m_aChildren == null) {
            this.m_aChildren = new CommonsArrayList<IMicroNode>();
        }
        this.m_aChildren.add(Math.min(n, this.m_aChildren.size()), abstractMicroNode);
        this._afterInsertAsChildOfThis(abstractMicroNode);
    }

    private void _afterRemoveChildOfThis(@Nonnull IMicroNode iMicroNode) {
        if (this.m_aChildren.contains(iMicroNode)) {
            throw new IllegalStateException("Child " + iMicroNode + " is contained more than once in it's parents list");
        }
        if (this.m_aChildren.isEmpty()) {
            this.m_aChildren = null;
        }
        ((AbstractMicroNode)iMicroNode).resetParentNode();
        this.onEvent(EMicroEvent.NODE_REMOVED, this, iMicroNode);
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChild(@Nonnull IMicroNode iMicroNode) {
        if (!iMicroNode.hasParent()) {
            throw new MicroException("The passed child node to be removed has no parent!");
        }
        if (this.m_aChildren == null || !this.m_aChildren.remove(iMicroNode)) {
            return EChange.UNCHANGED;
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveChildAtIndex(@Nonnegative int n) {
        IMicroNode iMicroNode = this.getChildAtIndex(n);
        if (iMicroNode == null) {
            return EChange.UNCHANGED;
        }
        if (!iMicroNode.hasParent()) {
            throw new MicroException("Internal inconsistency: the passed child node to be removed has no parent!");
        }
        if (this.m_aChildren.remove(n) != iMicroNode) {
            throw new MicroException("Internal inconsistency: remove resulted in an illegal object!");
        }
        this._afterRemoveChildOfThis(iMicroNode);
        return EChange.CHANGED;
    }

    @Override
    @Nonnull
    protected final EChange onRemoveAllChildren() {
        if (this.m_aChildren == null || this.m_aChildren.isEmpty()) {
            return EChange.UNCHANGED;
        }
        while (this.hasChildren()) {
            this.removeChildAtIndex(0);
        }
        return EChange.CHANGED;
    }

    @Override
    public final boolean hasChildren() {
        return this.m_aChildren != null && this.m_aChildren.isNotEmpty();
    }

    @Override
    @Nullable
    @ReturnsMutableCopy
    public final ICommonsList<IMicroNode> getAllChildren() {
        return this.m_aChildren == null ? null : (ICommonsList)this.m_aChildren.getClone();
    }

    @Override
    @Nullable
    public final IMicroNode getChildAtIndex(@Nonnegative int n) {
        return this.m_aChildren == null ? null : (IMicroNode)this.m_aChildren.getAtIndex(n);
    }

    @Override
    public final int getChildCount() {
        return this.m_aChildren == null ? 0 : this.m_aChildren.size();
    }

    @Override
    @Nullable
    public final IMicroNode getFirstChild() {
        return this.m_aChildren == null ? null : this.m_aChildren.getFirst();
    }

    @Override
    @Nullable
    public final IMicroNode getLastChild() {
        return this.m_aChildren == null ? null : this.m_aChildren.getLast();
    }

    private void _fillListPrefix(@Nonnull IMicroNode iMicroNode, @Nonnull List<IMicroNode> list) {
        if (iMicroNode.hasChildren()) {
            for (IMicroNode iMicroNode2 : iMicroNode.getAllChildren()) {
                list.add(iMicroNode2);
                this._fillListPrefix(iMicroNode2, list);
            }
        }
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsList<IMicroNode> getAllChildrenRecursive() {
        CommonsArrayList<IMicroNode> commonsArrayList = new CommonsArrayList<IMicroNode>();
        this._fillListPrefix(this, commonsArrayList);
        return commonsArrayList;
    }

    @Override
    @Nullable
    public String getTextContent() {
        if (this.hasNoChildren()) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (IMicroNode iMicroNode : this.directGetAllChildren()) {
            Object object;
            EMicroNodeType eMicroNodeType = iMicroNode.getType();
            if (eMicroNodeType.isText()) {
                object = (IMicroText)iMicroNode;
                if (((IMicroText)iMicroNode).isElementContentWhitespace()) continue;
                stringBuilder.append(object.getData());
                continue;
            }
            if (eMicroNodeType.isCDATA()) {
                object = (IMicroCDATA)iMicroNode;
                stringBuilder.append(object.getNodeValue());
                continue;
            }
            if (!(iMicroNode instanceof IMicroNodeWithChildren) || !StringHelper.hasText((String)(object = ((IMicroNodeWithChildren)iMicroNode).getTextContent()))) continue;
            stringBuilder.append((String)object);
        }
        return stringBuilder.toString();
    }

    @Override
    @Nullable
    public <DSTTYPE> DSTTYPE getTextContentWithConversion(@Nonnull Class<DSTTYPE> clazz) {
        String string = this.getTextContent();
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        DSTTYPE DSTTYPE = TypeConverter.convertIfNecessary(string, clazz);
        return DSTTYPE;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public boolean isEqualContent(@Nullable IMicroNode iMicroNode) {
        int n;
        if (iMicroNode == this) {
            return true;
        }
        if (iMicroNode == null || !this.getClass().equals(iMicroNode.getClass())) {
            return false;
        }
        AbstractMicroNodeWithChildren abstractMicroNodeWithChildren = (AbstractMicroNodeWithChildren)iMicroNode;
        if (this.m_aChildren == null && abstractMicroNodeWithChildren.m_aChildren == null) {
            return true;
        }
        if (this.m_aChildren == null || abstractMicroNodeWithChildren.m_aChildren == null) {
            return false;
        }
        int n2 = this.m_aChildren.size();
        if (n2 != (n = abstractMicroNodeWithChildren.m_aChildren.size())) {
            return false;
        }
        for (int i = 0; i < n2; ++i) {
            IMicroNode iMicroNode2;
            IMicroNode iMicroNode3 = (IMicroNode)this.m_aChildren.get(i);
            if (iMicroNode3.isEqualContent(iMicroNode2 = (IMicroNode)abstractMicroNodeWithChildren.m_aChildren.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("childrenCount", this.m_aChildren == null ? 0 : this.m_aChildren.size()).toString();
    }
}

