/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.hierarchy.IHasChildrenSorted;
import com.helger.commons.hierarchy.IHasParent;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.microdom.EMicroEvent;
import com.helger.commons.microdom.EMicroNodeType;
import com.helger.commons.microdom.IMicroCDATA;
import com.helger.commons.microdom.IMicroComment;
import com.helger.commons.microdom.IMicroContainer;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.IMicroEntityReference;
import com.helger.commons.microdom.IMicroEventTarget;
import com.helger.commons.microdom.IMicroProcessingInstruction;
import com.helger.commons.microdom.IMicroText;
import com.helger.commons.microdom.MicroException;
import com.helger.commons.state.EChange;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IMicroNode
extends ICloneable<IMicroNode>,
IHasChildrenSorted<IMicroNode>,
IHasParent<IMicroNode>,
Serializable {
    @Nonnull
    @Nonempty
    public String getNodeName();

    default public String getNodeValue() {
        return "";
    }

    @Override
    public boolean hasChildren();

    @Override
    @Nullable
    public ICommonsList<IMicroNode> getAllChildren();

    @Override
    @Nullable
    public IMicroNode getFirstChild();

    @Override
    @Nullable
    public IMicroNode getLastChild();

    @Nullable
    public ICommonsList<IMicroNode> getAllChildrenRecursive();

    @Nullable
    public IMicroNode getPreviousSibling();

    @Nullable
    public IMicroNode getNextSibling();

    public boolean hasParent();

    @Override
    @Nullable
    public IMicroNode getParent();

    @Nonnull
    public IMicroNode detachFromParent();

    @Nullable
    public IMicroElement getParentElementWithName(@Nullable String var1);

    @Nullable
    public IMicroElement getParentElementWithName(@Nullable String var1, @Nullable String var2);

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE appendChild(@Nullable NODETYPE var1) throws MicroException;

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertBefore(@Nullable NODETYPE var1, @Nonnull IMicroNode var2) throws MicroException;

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAfter(@Nullable NODETYPE var1, @Nonnull IMicroNode var2) throws MicroException;

    @Nullable
    public <NODETYPE extends IMicroNode> NODETYPE insertAtIndex(@Nonnegative int var1, @Nullable NODETYPE var2) throws MicroException;

    @Nonnull
    public IMicroText appendText(@Nullable CharSequence var1) throws MicroException;

    @Nonnull
    default public IMicroText appendText(@Nonnull char[] cArray) throws MicroException {
        return this.appendText(cArray, 0, cArray.length);
    }

    @Nonnull
    public IMicroText appendText(@Nonnull char[] var1, @Nonnegative int var2, @Nonnegative int var3) throws MicroException;

    @Nonnull
    public IMicroText appendTextWithConversion(@Nullable Object var1) throws MicroException;

    @Nonnull
    public IMicroText appendIgnorableWhitespaceText(@Nullable CharSequence var1) throws MicroException;

    @Nonnull
    default public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] cArray) throws MicroException {
        return this.appendIgnorableWhitespaceText(cArray, 0, cArray.length);
    }

    @Nonnull
    public IMicroText appendIgnorableWhitespaceText(@Nonnull char[] var1, @Nonnegative int var2, @Nonnegative int var3) throws MicroException;

    @Nonnull
    public IMicroCDATA appendCDATA(@Nullable CharSequence var1) throws MicroException;

    @Nonnull
    default public IMicroCDATA appendCDATA(@Nonnull char[] cArray) throws MicroException {
        return this.appendCDATA(cArray, 0, cArray.length);
    }

    @Nonnull
    public IMicroCDATA appendCDATA(@Nonnull char[] var1, @Nonnegative int var2, @Nonnegative int var3) throws MicroException;

    @Nonnull
    public IMicroCDATA appendCDATAWithConversion(@Nullable Object var1) throws MicroException;

    @Nonnull
    public IMicroComment appendComment(@Nullable CharSequence var1) throws MicroException;

    @Nonnull
    default public IMicroComment appendComment(@Nonnull char[] cArray) throws MicroException {
        return this.appendComment(cArray, 0, cArray.length);
    }

    @Nonnull
    public IMicroComment appendComment(@Nonnull char[] var1, @Nonnegative int var2, @Nonnegative int var3) throws MicroException;

    @Nonnull
    public IMicroComment appendCommentWithConversion(@Nullable Object var1) throws MicroException;

    @Nonnull
    public IMicroEntityReference appendEntityReference(@Nonnull String var1) throws MicroException;

    @Nonnull
    public IMicroElement appendElement(@Nonnull @Nonempty String var1) throws MicroException;

    @Nonnull
    public IMicroElement appendElement(@Nullable String var1, @Nonnull @Nonempty String var2) throws MicroException;

    @Nonnull
    public IMicroProcessingInstruction appendProcessingInstruction(@Nonnull @Nonempty String var1, @Nullable String var2) throws MicroException;

    @Nonnull
    public IMicroContainer appendContainer() throws MicroException;

    @Nonnull
    public EChange removeChild(@Nonnull IMicroNode var1);

    @Nonnull
    public EChange removeChildAtIndex(@Nonnegative int var1);

    @Nonnull
    public EChange removeAllChildren();

    @Nonnull
    public EChange replaceChild(@Nonnull IMicroNode var1, @Nonnull IMicroNode var2);

    @Nonnull
    public EMicroNodeType getType();

    public boolean isDocument();

    public boolean isDocumentType();

    public boolean isText();

    public boolean isCDATA();

    public boolean isComment();

    public boolean isEntityReference();

    public boolean isElement();

    public boolean isProcessingInstruction();

    public boolean isContainer();

    @Nonnull
    public EChange registerEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    public EChange unregisterEventTarget(@Nonnull EMicroEvent var1, @Nonnull IMicroEventTarget var2);

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsMap<EMicroEvent, ICommonsSet<IMicroEventTarget>> getAllEventTargets();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IMicroEventTarget> getAllEventTargets(@Nullable EMicroEvent var1);

    public boolean isEqualContent(@Nullable IMicroNode var1);
}

