/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.convert;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.IMicroTypeConverter;
import com.helger.commons.microdom.convert.StringMicroTypeConverter;
import com.helger.commons.typeconvert.TypeConverter;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class StringBasedMicroTypeConverter
implements IMicroTypeConverter {
    private final Class<?> m_aNativeClass;

    public StringBasedMicroTypeConverter(@Nonnull Class<?> clazz) {
        ValueEnforcer.notNull(clazz, "NativeClass");
        this.m_aNativeClass = clazz;
    }

    @Override
    @Nonnull
    public IMicroElement convertToMicroElement(@Nonnull Object object, @Nullable String string, @Nonnull @Nonempty String string2) {
        String string3 = TypeConverter.convertIfNecessary(object, String.class);
        return StringMicroTypeConverter.getInstance().convertToMicroElement(string3, string, string2);
    }

    @Override
    @Nonnull
    public Object convertToNative(@Nonnull IMicroElement iMicroElement) {
        String string = StringMicroTypeConverter.getInstance().convertToNative(iMicroElement);
        return TypeConverter.convertIfNecessary(string, this.m_aNativeClass);
    }
}

