/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.microdom.util;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.hierarchy.IChildrenProvider;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.string.StringHelper;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ChildrenProviderElementWithName
implements IChildrenProvider<IMicroElement> {
    private final String m_sNamespaceURI;
    private final String m_sTagName;

    public ChildrenProviderElementWithName(@Nonnull @Nonempty String string) {
        this(null, string);
    }

    public ChildrenProviderElementWithName(@Nullable String string, @Nonnull @Nonempty String string2) {
        this.m_sNamespaceURI = string;
        this.m_sTagName = ValueEnforcer.notEmpty(string2, "TagName");
    }

    @Override
    public boolean hasChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null || !iMicroElement.isElement()) {
            return false;
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.hasChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.hasChildElements(this.m_sTagName);
    }

    @Override
    @Nonnegative
    public int getChildCount(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return 0;
        }
        return this.getAllChildren(iMicroElement).size();
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<? extends IMicroElement> getAllChildren(@Nullable IMicroElement iMicroElement) {
        if (iMicroElement == null) {
            return new CommonsArrayList();
        }
        if (StringHelper.hasText(this.m_sNamespaceURI)) {
            return iMicroElement.getAllChildElements(this.m_sNamespaceURI, this.m_sTagName);
        }
        return iMicroElement.getAllChildElements(this.m_sTagName);
    }
}

