/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mime;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.CommonsLinkedHashSet;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.collection.ext.ICommonsOrderedSet;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.collection.multimap.IMultiMapListBased;
import com.helger.commons.collection.multimap.MultiTreeMapArrayListBased;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.io.file.FilenameHelper;
import com.helger.commons.io.resource.ClassPathResource;
import com.helger.commons.io.resource.IReadableResource;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroDocument;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroReader;
import com.helger.commons.mime.IMimeType;
import com.helger.commons.mime.MimeTypeInfo;
import com.helger.commons.state.EChange;
import com.helger.commons.string.StringHelper;
import java.io.File;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class MimeTypeInfoManager {
    public static final String MIME_TYPE_INFO_XML = "codelists/mime-type-info.xml";
    private static boolean s_bDefaultInstantiated = false;
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<MimeTypeInfo> m_aList = new CommonsArrayList<MimeTypeInfo>();
    @GuardedBy(value="m_aRWLock")
    private final IMultiMapListBased<IMimeType, MimeTypeInfo> m_aMapMimeType = new MultiTreeMapArrayListBased<IMimeType, MimeTypeInfo>();
    @GuardedBy(value="m_aRWLock")
    private final IMultiMapListBased<String, MimeTypeInfo> m_aMapExt = new MultiTreeMapArrayListBased<String, MimeTypeInfo>();

    public static boolean isDefaultInstantiated() {
        return s_bDefaultInstantiated;
    }

    @Nonnull
    public static MimeTypeInfoManager getDefaultInstance() {
        MimeTypeInfoManager mimeTypeInfoManager = SingletonHolder.s_aInstance;
        s_bDefaultInstantiated = true;
        return mimeTypeInfoManager;
    }

    @Nonnull
    public MimeTypeInfoManager readDefault() {
        return this.read(new ClassPathResource(MIME_TYPE_INFO_XML));
    }

    @Nonnull
    public MimeTypeInfoManager read(@Nonnull IReadableResource iReadableResource) {
        ValueEnforcer.notNull(iReadableResource, "Resource");
        IMicroDocument iMicroDocument = MicroReader.readMicroXML(iReadableResource);
        if (iMicroDocument == null) {
            throw new IllegalArgumentException("Failed to read MimeTypeInfo resource " + iReadableResource);
        }
        for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements()) {
            MimeTypeInfo mimeTypeInfo = MicroTypeConverter.convertToNative(iMicroElement, MimeTypeInfo.class);
            this.registerMimeType(mimeTypeInfo);
        }
        return this;
    }

    @Nonnull
    public EChange clearCache() {
        return this.m_aRWLock.writeLocked(() -> {
            EChange eChange = this.m_aList.removeAll();
            if (!this.m_aMapExt.isEmpty()) {
                this.m_aMapExt.clear();
                eChange = EChange.CHANGED;
            }
            if (!this.m_aMapMimeType.isEmpty()) {
                this.m_aMapMimeType.clear();
                eChange = EChange.CHANGED;
            }
            return eChange;
        });
    }

    public void reinitializeToDefault() {
        this.clearCache();
        this.readDefault();
    }

    @Nonnull
    @ReturnsMutableCopy
    public IMicroDocument getAsDocument() {
        MicroDocument microDocument = new MicroDocument();
        IMicroElement iMicroElement = microDocument.appendElement("mime-type-info");
        this.m_aRWLock.readLocked(() -> {
            for (MimeTypeInfo mimeTypeInfo : this.m_aList.getSorted(Comparator.comparing(MimeTypeInfo::getPrimaryMimeTypeString))) {
                iMicroElement.appendChild(MicroTypeConverter.convertToMicroElement(mimeTypeInfo, "item"));
            }
        });
        return microDocument;
    }

    public void registerMimeType(@Nonnull MimeTypeInfo mimeTypeInfo) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        ICommonsSet<MimeTypeInfo.MimeTypeWithSource> iCommonsSet = mimeTypeInfo.getAllMimeTypesWithSource();
        ICommonsOrderedSet<MimeTypeInfo.ExtensionWithSource> iCommonsOrderedSet = mimeTypeInfo.getAllExtensionsWithSource();
        this.m_aRWLock.readLocked(() -> {
            for (MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource : iCommonsSet) {
                ICommonsList iCommonsList = (ICommonsList)this.m_aMapMimeType.get(mimeTypeWithSource.getMimeType());
                if (iCommonsList == null) continue;
                throw new IllegalArgumentException("Cannot register " + mimeTypeInfo + ". A mapping for mime type '" + mimeTypeWithSource + "' is already registered: " + iCommonsList);
            }
        });
        this.m_aRWLock.writeLocked(() -> {
            this.m_aList.add(mimeTypeInfo);
            for (Object object : iCommonsSet) {
                this.m_aMapMimeType.putSingle(((MimeTypeInfo.MimeTypeWithSource)object).getMimeType(), mimeTypeInfo);
            }
            for (Object object : iCommonsOrderedSet) {
                this.m_aMapExt.putSingle(((MimeTypeInfo.ExtensionWithSource)object).getExtension(), mimeTypeInfo);
            }
        });
    }

    public final void addExtension(@Nonnull MimeTypeInfo mimeTypeInfo, @Nonnull MimeTypeInfo.ExtensionWithSource extensionWithSource) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        ValueEnforcer.notNull(extensionWithSource, "Ext");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMapExt.putSingle(extensionWithSource.getExtension(), mimeTypeInfo);
            mimeTypeInfo.addExtension(extensionWithSource);
        });
    }

    public final void addMimeType(@Nonnull MimeTypeInfo mimeTypeInfo, @Nonnull MimeTypeInfo.MimeTypeWithSource mimeTypeWithSource) {
        ValueEnforcer.notNull(mimeTypeInfo, "Info");
        ValueEnforcer.notNull(mimeTypeWithSource, "MimeType");
        this.m_aRWLock.writeLocked(() -> {
            this.m_aMapMimeType.putSingle(mimeTypeWithSource.getMimeType(), mimeTypeInfo);
            mimeTypeInfo.addMimeType(mimeTypeWithSource);
        });
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeInfo> getAllInfosOfFilename(@Nullable File file) {
        if (file == null) {
            return null;
        }
        String string = FilenameHelper.getExtension(file);
        return this.getAllInfosOfExtension(string);
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeInfo> getAllInfosOfFilename(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllInfosOfExtension(string2);
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeInfo> getAllInfosOfExtension(@Nullable String string) {
        if (string == null) {
            return null;
        }
        return this.m_aRWLock.readLocked(() -> {
            ICommonsList iCommonsList = (ICommonsList)this.m_aMapExt.get(string);
            if (iCommonsList == null) {
                iCommonsList = (ICommonsList)this.m_aMapExt.get(string.toLowerCase(Locale.US));
            }
            return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
        });
    }

    @Nullable
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeInfo> getAllInfosOfMimeType(@Nullable IMimeType iMimeType) {
        if (iMimeType == null) {
            return null;
        }
        ICommonsList iCommonsList = this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aMapMimeType.get(iMimeType));
        return iCommonsList == null ? null : (ICommonsList)iCommonsList.getClone();
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<MimeTypeInfo> getAllMimeTypeInfos() {
        return this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aList.getClone());
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMimeType> getAllMimeTypes() {
        CommonsLinkedHashSet<IMimeType> commonsLinkedHashSet = new CommonsLinkedHashSet<IMimeType>();
        this.m_aRWLock.readLocked(() -> this.m_aList.forEach(mimeTypeInfo -> commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypes())));
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllMimeTypeStrings() {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        this.m_aRWLock.readLocked(() -> this.m_aList.forEach(mimeTypeInfo -> commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypeStrings())));
        return commonsLinkedHashSet;
    }

    public boolean containsMimeTypeForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.containsMimeTypeForExtension(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<IMimeType> getAllMimeTypesForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllMimeTypesForExtension(string2);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsSet<String> getAllMimeTypeStringsForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getAllMimeTypeStringsForExtension(string2);
    }

    @Nullable
    public IMimeType getPrimaryMimeTypeForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getPrimaryMimeTypeForExtension(string2);
    }

    @Nullable
    public String getPrimaryMimeTypeStringForFilename(@Nonnull @Nonempty String string) {
        ValueEnforcer.notEmpty(string, "Filename");
        String string2 = FilenameHelper.getExtension(string);
        return this.getPrimaryMimeTypeStringForExtension(string2);
    }

    public boolean containsMimeTypeForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        return CollectionHelper.isNotEmpty(iCommonsList);
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<IMimeType> getAllMimeTypesForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        CommonsLinkedHashSet<IMimeType> commonsLinkedHashSet = new CommonsLinkedHashSet<IMimeType>();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypes());
            }
        }
        return commonsLinkedHashSet;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllMimeTypeStringsForExtension(@Nonnull String string) {
        ValueEnforcer.notNull(string, "Extension");
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllMimeTypeStrings());
            }
        }
        return commonsLinkedHashSet;
    }

    @Nullable
    public IMimeType getPrimaryMimeTypeForExtension(@Nonnull String string) {
        Iterator iterator;
        ValueEnforcer.notNull(string, "Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null && (iterator = iCommonsList.iterator()).hasNext()) {
            MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)iterator.next();
            return mimeTypeInfo.getPrimaryMimeType();
        }
        return null;
    }

    @Nullable
    public String getPrimaryMimeTypeStringForExtension(@Nonnull String string) {
        Iterator iterator;
        ValueEnforcer.notNull(string, "Extension");
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfExtension(string);
        if (iCommonsList != null && (iterator = iCommonsList.iterator()).hasNext()) {
            MimeTypeInfo mimeTypeInfo = (MimeTypeInfo)iterator.next();
            return mimeTypeInfo.getPrimaryMimeTypeString();
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllExtensionsOfMimeType(@Nullable IMimeType iMimeType) {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllExtensions());
            }
        }
        return commonsLinkedHashSet;
    }

    @Nullable
    public String getPrimaryExtensionOfMimeType(@Nullable IMimeType iMimeType) {
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                String string = mimeTypeInfo.getPrimaryExtension();
                if (string == null) continue;
                return string;
            }
        }
        return null;
    }

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedSet<String> getAllGlobsOfMimeType(@Nullable IMimeType iMimeType) {
        CommonsLinkedHashSet<String> commonsLinkedHashSet = new CommonsLinkedHashSet<String>();
        ICommonsList<MimeTypeInfo> iCommonsList = this.getAllInfosOfMimeType(iMimeType);
        if (iCommonsList != null) {
            for (MimeTypeInfo mimeTypeInfo : iCommonsList) {
                commonsLinkedHashSet.addAll(mimeTypeInfo.getAllGlobs());
            }
        }
        return commonsLinkedHashSet;
    }

    private static final class SingletonHolder {
        private static final MimeTypeInfoManager s_aInstance = new MimeTypeInfoManager().readDefault();

        private SingletonHolder() {
        }
    }
}

