/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.mock;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.callback.IThrowingRunnable;
import com.helger.commons.charset.CCharset;
import com.helger.commons.collection.ext.CommonsVector;
import com.helger.commons.concurrent.ManagedExecutorService;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.io.file.FileHelper;
import com.helger.commons.io.file.iterate.FileSystemIterator;
import com.helger.commons.io.stream.NonBlockingBufferedReader;
import com.helger.commons.io.stream.NonBlockingByteArrayOutputStream;
import com.helger.commons.io.stream.StreamHelper;
import com.helger.commons.io.streamprovider.ByteArrayInputStreamProvider;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.lang.GenericReflection;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.lang.StackTraceHelper;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.convert.MicroTypeConverter;
import com.helger.commons.microdom.serialize.MicroReader;
import com.helger.commons.microdom.serialize.MicroWriter;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import javax.jws.WebService;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class CommonsTestHelper {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CommonsTestHelper.class);
    private static final CommonsTestHelper s_aInstance = new CommonsTestHelper();

    private CommonsTestHelper() {
    }

    private static void _fail(@Nonnull String string) {
        throw new IllegalStateException(string);
    }

    private static void _assertTrue(@Nonnull String string, boolean bl) {
        if (!bl) {
            CommonsTestHelper._fail(string);
        }
    }

    private static void _assertFalse(@Nonnull String string, boolean bl) {
        if (bl) {
            CommonsTestHelper._fail(string);
        }
    }

    private static void _assertNotNull(@Nonnull String string, Object object) {
        if (object == null) {
            CommonsTestHelper._fail(string);
        }
    }

    private static <T> void _assertEquals(@Nonnull String string, @Nullable T t, @Nullable T t2) {
        if (!EqualsHelper.equals(t, t2)) {
            CommonsTestHelper._fail(string + "\nOBJ1: " + t + "\nOBJ2: " + t2);
        }
    }

    @SuppressFBWarnings(value={"EC_NULL_ARG"})
    private static <DATATYPE> void _testEqualsImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("Passed objects are not equal", DATATYPE.equals(DATATYPE));
        CommonsTestHelper._assertFalse("Object may no be equal to String", DATATYPE.equals("any string"));
        CommonsTestHelper._assertFalse("Object may no be equal to null", DATATYPE.equals(null));
    }

    public static <DATATYPE> void testEqualsImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE2.equals(DATATYPE));
    }

    public static <DATATYPE> void testEqualsImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testEqualsImplementation(DATATYPE);
        CommonsTestHelper._testEqualsImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE2.equals(DATATYPE));
    }

    private static <DATATYPE> void _testHashcodeImplementation(@Nonnull DATATYPE DATATYPE) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", DATATYPE);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE.hashCode());
        CommonsTestHelper._assertFalse("hashCode() may not be 0", DATATYPE.hashCode() == 0);
    }

    public static <DATATYPE> void testHashcodeImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE.hashCode() == DATATYPE2.hashCode());
        CommonsTestHelper._assertTrue("hashCode() invocations must be consistent", DATATYPE2.hashCode() == DATATYPE.hashCode());
    }

    public static <DATATYPE> void testHashcodeImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper._testHashcodeImplementation(DATATYPE);
        CommonsTestHelper._testHashcodeImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
        int n = DATATYPE.hashCode();
        int n2 = DATATYPE2.hashCode();
        CommonsTestHelper._assertFalse("hashCode() may not be the same for both objects", n == n2);
    }

    public static void testToStringImplementation(@Nonnull Object object) {
        CommonsTestHelper._assertNotNull("Passed object may not be null!", object);
        CommonsTestHelper._assertNotNull("toString() may not return null!", object.toString());
        CommonsTestHelper._assertTrue("toString() may not return an empty string!", object.toString().length() > 0);
        CommonsTestHelper._assertTrue("toString() invocations must be consistent", object.toString().equals(object.toString()));
    }

    public static <DATATYPE> void testToStringImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertTrue("Passed objects are not identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    public static <DATATYPE> void testToStringImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testToStringImplementation(DATATYPE);
        CommonsTestHelper.testToStringImplementation(DATATYPE2);
        CommonsTestHelper._assertFalse("Passed objects are identical!", DATATYPE.equals(DATATYPE2));
        CommonsTestHelper._assertFalse("This test may not be used with the same object!", DATATYPE == DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithEqualContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testEqualsImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testHashcodeImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testToStringImplementationWithEqualContentObject(DATATYPE, DATATYPE2);
    }

    public static <DATATYPE> void testDefaultImplementationWithDifferentContentObject(@Nonnull DATATYPE DATATYPE, @Nonnull DATATYPE DATATYPE2) {
        CommonsTestHelper.testEqualsImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testHashcodeImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
        CommonsTestHelper.testToStringImplementationWithDifferentContentObject(DATATYPE, DATATYPE2);
    }

    @Nonnull
    public static <DATATYPE extends Serializable> DATATYPE testDefaultSerialization(@Nonnull DATATYPE DATATYPE) {
        try {
            NonBlockingByteArrayOutputStream nonBlockingByteArrayOutputStream = new NonBlockingByteArrayOutputStream();
            Object object = new ObjectOutputStream(nonBlockingByteArrayOutputStream);
            Object object2 = null;
            try {
                ((ObjectOutputStream)object).writeObject(DATATYPE);
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                if (object != null) {
                    if (object2 != null) {
                        try {
                            ((ObjectOutputStream)object).close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object2).addSuppressed(throwable);
                        }
                    } else {
                        ((ObjectOutputStream)object).close();
                    }
                }
            }
            object2 = new ObjectInputStream(new ByteArrayInputStreamProvider(nonBlockingByteArrayOutputStream.toByteArray()).getInputStream());
            Throwable throwable = null;
            try {
                object = (Serializable)GenericReflection.uncheckedCast(((ObjectInputStream)object2).readObject());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (object2 != null) {
                    if (throwable != null) {
                        try {
                            ((ObjectInputStream)object2).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ((ObjectInputStream)object2).close();
                    }
                }
            }
            CommonsTestHelper.testDefaultImplementationWithEqualContentObject(DATATYPE, object);
            return (DATATYPE)object;
        }
        catch (Throwable throwable) {
            throw new IllegalStateException("testDefaultSerialization failed", throwable);
        }
    }

    public static void testGetClone(@Nonnull ICloneable<?> iCloneable) {
        Object obj = iCloneable.getClone();
        CommonsTestHelper._assertNotNull("Clone returned a null object", obj);
        CommonsTestHelper._assertTrue("Clone returned a different class than the original one", obj.getClass().equals(iCloneable.getClass()));
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(iCloneable, obj);
    }

    public static <T> T testMicroTypeConversion(@Nonnull T t) {
        Assert.assertNotNull(t);
        IMicroElement iMicroElement = MicroTypeConverter.convertToMicroElement(t, "test");
        Assert.assertNotNull((Object)iMicroElement);
        Object obj = MicroTypeConverter.convertToNative(iMicroElement, t.getClass());
        Assert.assertNotNull(obj);
        IMicroElement iMicroElement2 = MicroTypeConverter.convertToMicroElement(obj, "test");
        Assert.assertNotNull((Object)iMicroElement2);
        String string = MicroWriter.getXMLString(iMicroElement);
        String string2 = MicroWriter.getXMLString(iMicroElement2);
        CommonsTestHelper._assertEquals("XML representation must be identical", string, string2);
        CommonsTestHelper.testDefaultImplementationWithEqualContentObject(t, obj);
        return (T)GenericReflection.uncheckedCast(obj);
    }

    public static void testInParallel(@Nonnegative int n, @Nonnull IThrowingRunnable<? extends Throwable> iThrowingRunnable) {
        ValueEnforcer.isGE0(n, "Calls");
        ValueEnforcer.notNull(iThrowingRunnable, "Runnable");
        ExecutorService executorService = Executors.newFixedThreadPool(20);
        CommonsVector commonsVector = new CommonsVector();
        for (int i = 0; i < n; ++i) {
            executorService.submit(() -> {
                try {
                    iThrowingRunnable.run();
                }
                catch (Throwable throwable) {
                    commonsVector.add(throwable.getMessage() + "\n" + StackTraceHelper.getStackAsString(throwable));
                }
            });
        }
        ManagedExecutorService.shutdownAndWaitUntilAllTasksAreFinished(executorService);
        if (!commonsVector.isEmpty()) {
            CommonsTestHelper._fail(StringHelper.getImploded(commonsVector));
        }
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid(@Nonnull String string, boolean bl) throws Exception {
        int n = 0;
        File file = new File(string);
        if (file.exists() && file.isDirectory()) {
            for (File file2 : new FileSystemIterator(string)) {
                Object object;
                block18: {
                    if (!file2.isFile()) continue;
                    s_aLogger.info("Checking SPI file " + file2.getAbsolutePath());
                    try {
                        Class.forName(file2.getName());
                    }
                    catch (Throwable throwable) {
                        object = "No interface representing " + file2.getName() + " exists: " + ClassHelper.getClassLocalName(throwable) + " - " + throwable.getMessage();
                        s_aLogger.warn((String)object);
                        if (bl) break block18;
                        throw new Exception((String)object);
                    }
                }
                try {
                    NonBlockingBufferedReader nonBlockingBufferedReader = new NonBlockingBufferedReader(StreamHelper.createReader(FileHelper.getInputStream(file2), CCharset.CHARSET_SERVICE_LOADER_OBJ));
                    object = null;
                    try {
                        String string2;
                        int n2 = 0;
                        while ((string2 = nonBlockingBufferedReader.readLine()) != null) {
                            String string3 = StringHelper.trim(string2);
                            if (!StringHelper.hasText(string3)) continue;
                            Class.forName(string2);
                            ++n2;
                            ++n;
                        }
                        if (n2 == 0) {
                            s_aLogger.warn("  Contains no single valid implementation!");
                            continue;
                        }
                        s_aLogger.info("  All implementations (" + n2 + ") are valid!");
                    }
                    catch (Throwable throwable) {
                        object = throwable;
                        throw throwable;
                    }
                    finally {
                        if (nonBlockingBufferedReader == null) continue;
                        if (object != null) {
                            try {
                                nonBlockingBufferedReader.close();
                            }
                            catch (Throwable throwable) {
                                ((Throwable)object).addSuppressed(throwable);
                            }
                            continue;
                        }
                        nonBlockingBufferedReader.close();
                    }
                }
                catch (Throwable throwable) {
                    s_aLogger.warn("  Error checking content: " + throwable.getMessage());
                    if (bl) continue;
                    throw new Exception("Error checking SPI file " + file2.getAbsolutePath(), throwable);
                }
            }
        }
        return n;
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid() throws Exception {
        return CommonsTestHelper.testIfAllSPIImplementationsAreValid(false);
    }

    @Nonnegative
    public static int testIfAllSPIImplementationsAreValid(boolean bl) throws Exception {
        int n = 0;
        n += CommonsTestHelper.testIfAllSPIImplementationsAreValid("src/main/resources/META-INF/services", bl);
        return n += CommonsTestHelper.testIfAllSPIImplementationsAreValid("src/test/resources/META-INF/services", bl);
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(@Nonnull String string, boolean bl) throws Exception {
        File file = new File(string, "sun-jaxws.xml");
        if (file.isFile()) {
            s_aLogger.info("Checking file " + file.getAbsolutePath());
            IMicroDocument iMicroDocument = MicroReader.readMicroXML(file);
            if (iMicroDocument == null) {
                s_aLogger.warn("The file is invalid XML!");
                if (!bl) {
                    throw new Exception("The file is invalid XML!");
                }
            } else {
                for (IMicroElement iMicroElement : iMicroDocument.getDocumentElement().getAllChildElements("endpoint")) {
                    Class<?> clazz;
                    String string2;
                    String string3;
                    block12: {
                        WebService webService;
                        Class<?> clazz2;
                        String string4;
                        block11: {
                            string3 = iMicroElement.getAttributeValue("name");
                            string4 = iMicroElement.getAttributeValue("implementation");
                            clazz2 = null;
                            try {
                                clazz2 = Class.forName(string4);
                            }
                            catch (Throwable throwable) {
                                string2 = "The implementation class '" + string4 + "' of endpoint '" + string3 + "' is invalid - " + throwable.getMessage();
                                s_aLogger.warn(string2);
                                if (bl) break block11;
                                throw new Exception(string2);
                            }
                        }
                        if (clazz2 == null) continue;
                        if (s_aLogger.isDebugEnabled()) {
                            s_aLogger.debug("Implementation class '" + string4 + "' found");
                        }
                        if ((webService = clazz2.getAnnotation(WebService.class)) == null) {
                            string2 = "The implementation class '" + string4 + "' is missing the @WebService annotation";
                            s_aLogger.warn(string2);
                            if (bl) continue;
                            throw new Exception(string2);
                        }
                        string2 = webService.endpointInterface();
                        clazz = null;
                        try {
                            clazz = Class.forName(string2);
                        }
                        catch (Throwable throwable) {
                            String string5 = "The endpoint interface class '" + string2 + "' of implementation class '" + string4 + "' is invalid - " + throwable.getMessage();
                            s_aLogger.warn(string5);
                            if (bl) break block12;
                            throw new Exception(string5);
                        }
                    }
                    if (clazz == null || clazz.isInterface()) continue;
                    String string6 = "The endpoint interface class '" + string2 + "' of endpoint '" + string3 + "' is not an interface!";
                    s_aLogger.warn(string6);
                    if (bl) continue;
                    throw new Exception(string6);
                }
            }
        }
        return 0;
    }

    @Nonnegative
    public static int testIfAllSunJaxwsFilesAreValid(boolean bl) throws Exception {
        int n = 0;
        n += CommonsTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/resources/WEB-INF", bl);
        return n += CommonsTestHelper.testIfAllSunJaxwsFilesAreValid("src/main/webapp/WEB-INF", bl);
    }

    public static void testIfAllSunJaxwsFilesAreValid() throws Exception {
        CommonsTestHelper.testIfAllSunJaxwsFilesAreValid(false);
    }
}

