/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.random;

import java.security.SecureRandom;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public final class VerySecureRandom {
    private static final Logger s_aLogger = LoggerFactory.getLogger(VerySecureRandom.class);
    private static final SecureRandom s_aSecureRandom;
    private static final VerySecureRandom s_aInstance;
    private static final AtomicInteger s_aCounter;

    @Nonnull
    private static SecureRandom _createSecureRandomInstance() {
        SecureRandom secureRandom;
        block9: {
            try {
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Trying to get SecureRandom: IBMSecureRandom, IBMJCE");
                }
                secureRandom = SecureRandom.getInstance("IBMSecureRandom", "IBMJCE");
                if (s_aLogger.isDebugEnabled()) {
                    s_aLogger.debug("Using SecureRandom: IBMSecureRandom, IBMJCE");
                }
            }
            catch (Throwable throwable) {
                try {
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Trying to get SecureRandom: SHA1PRNG");
                    }
                    secureRandom = SecureRandom.getInstance("SHA1PRNG");
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Using SecureRandom: SHA1PRNG");
                    }
                }
                catch (Throwable throwable2) {
                    if (s_aLogger.isDebugEnabled()) {
                        s_aLogger.debug("Trying to get default SecureRandom");
                    }
                    secureRandom = new SecureRandom();
                    if (!s_aLogger.isDebugEnabled()) break block9;
                    s_aLogger.debug("Using default SecureRandom");
                }
            }
        }
        return secureRandom;
    }

    private VerySecureRandom() {
    }

    @Nonnull
    public static SecureRandom getInstance() {
        if (s_aCounter.incrementAndGet() % 20 == 0) {
            if (s_aLogger.isDebugEnabled()) {
                s_aLogger.debug("Re-seeding VerySecureRandom");
            }
            s_aSecureRandom.setSeed(s_aSecureRandom.generateSeed(10));
        }
        return s_aSecureRandom;
    }

    static {
        SecureRandom secureRandom = VerySecureRandom._createSecureRandomInstance();
        secureRandom.setSeed(System.currentTimeMillis());
        secureRandom.nextBytes(new byte[128]);
        if (s_aLogger.isDebugEnabled()) {
            s_aLogger.debug("Generating intial seed for VerySecureRandom");
        }
        byte[] byArray = secureRandom.generateSeed(16);
        s_aSecureRandom = VerySecureRandom._createSecureRandomInstance();
        s_aSecureRandom.setSeed(byArray);
        s_aInstance = new VerySecureRandom();
        s_aCounter = new AtomicInteger(0);
    }
}

