/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope;

import com.helger.commons.annotation.Nonempty;
import com.helger.commons.lang.ClassHelper;
import com.helger.commons.scope.AbstractMapBasedScope;
import com.helger.commons.scope.ISessionApplicationScope;
import com.helger.commons.scope.ScopeHelper;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class SessionApplicationScope
extends AbstractMapBasedScope
implements ISessionApplicationScope {
    private static final Logger s_aLogger = LoggerFactory.getLogger(SessionApplicationScope.class);

    public SessionApplicationScope(@Nonnull @Nonempty String string) {
        super(string);
        if (ScopeHelper.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Created session application scope '" + string + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    public void initScope() {
    }

    @Override
    protected void preDestroy() {
        if (ScopeHelper.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroying session application scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }

    @Override
    protected void postDestroy() {
        if (ScopeHelper.debugSessionApplicationScopeLifeCycle(s_aLogger)) {
            s_aLogger.info("Destroyed session application scope '" + this.getID() + "' of class " + ClassHelper.getClassLocalName(this), ScopeHelper.getDebugStackTrace());
        }
    }
}

