/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.scope.mgr;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.UsedViaReflection;
import com.helger.commons.collection.ext.CommonsHashMap;
import com.helger.commons.collection.ext.CommonsHashSet;
import com.helger.commons.collection.ext.ICommonsMap;
import com.helger.commons.collection.ext.ICommonsSet;
import com.helger.commons.scope.IScope;
import com.helger.commons.scope.ISessionScope;
import com.helger.commons.scope.singleton.AbstractGlobalSingleton;
import com.helger.commons.scope.spi.ScopeSPIManager;
import com.helger.commons.state.EChange;
import com.helger.commons.statistics.IMutableStatisticsHandlerCounter;
import com.helger.commons.statistics.StatisticsManager;
import com.helger.commons.string.StringHelper;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class ScopeSessionManager
extends AbstractGlobalSingleton {
    public static final boolean DEFAULT_DESTROY_ALL_SESSIONS_ON_SCOPE_END = true;
    public static final boolean DEFAULT_END_ALL_SESSIONS_ON_SCOPE_END = true;
    private static final Logger s_aLogger = LoggerFactory.getLogger(ScopeSessionManager.class);
    private static final IMutableStatisticsHandlerCounter s_aUniqueSessionCounter = StatisticsManager.getCounterHandler(ScopeSessionManager.class.getName() + "$UNIQUE_SESSIONS");
    private static volatile ScopeSessionManager s_aInstance = null;
    @GuardedBy(value="m_aRWLock")
    private final ICommonsMap<String, ISessionScope> m_aSessionScopes = new CommonsHashMap<String, ISessionScope>();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsSet<String> m_aSessionsInDestruction = new CommonsHashSet<String>();
    @GuardedBy(value="m_aRWLock")
    private boolean m_bDestroyAllSessionsOnScopeEnd = true;
    @GuardedBy(value="m_aRWLock")
    private boolean m_bEndAllSessionsOnScopeEnd = true;

    @Deprecated
    @UsedViaReflection
    public ScopeSessionManager() {
    }

    @Nonnull
    public static ScopeSessionManager getInstance() {
        if (s_aInstance == null) {
            s_aInstance = ScopeSessionManager.getGlobalSingleton(ScopeSessionManager.class);
        }
        return s_aInstance;
    }

    @Nullable
    public ISessionScope getSessionScopeOfID(@Nullable String string) {
        if (StringHelper.hasNoText(string)) {
            return null;
        }
        return this.m_aRWLock.readLocked(() -> (ISessionScope)this.m_aSessionScopes.get(string));
    }

    public void onScopeBegin(@Nonnull ISessionScope iSessionScope) {
        ValueEnforcer.notNull(iSessionScope, "SessionScope");
        String string = iSessionScope.getID();
        this.m_aRWLock.writeLocked(() -> {
            if (this.m_aSessionScopes.put(string, iSessionScope) != null) {
                s_aLogger.error("Overwriting session scope with ID '" + string + "'");
            }
        });
        iSessionScope.initScope();
        ScopeSPIManager.getInstance().onSessionScopeBegin(iSessionScope);
        s_aUniqueSessionCounter.increment();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onScopeEnd(@Nonnull ISessionScope iSessionScope) {
        String string;
        boolean bl;
        ValueEnforcer.notNull(iSessionScope, "SessionScope");
        if (iSessionScope.isValid() && (bl = this.m_aRWLock.writeLocked(() -> this.lambda$onScopeEnd$553(string = iSessionScope.getID(), iSessionScope)))) {
            try {
                ScopeSPIManager.getInstance().onSessionScopeEnd(iSessionScope);
                iSessionScope.destroyScope();
            }
            finally {
                this.m_aRWLock.writeLocked(() -> this.m_aSessionsInDestruction.remove(string));
            }
        }
    }

    public boolean containsAnySession() {
        return this.m_aRWLock.readLocked(() -> !this.m_aSessionScopes.isEmpty());
    }

    @Nonnegative
    public int getSessionCount() {
        return this.m_aRWLock.readLocked(() -> this.m_aSessionScopes.size());
    }

    @Nonnull
    @ReturnsMutableCopy
    public Collection<? extends ISessionScope> getAllSessionScopes() {
        return this.m_aRWLock.readLocked(() -> this.m_aSessionScopes.copyOfValues());
    }

    private void _checkIfAnySessionsExist() {
        if (this.containsAnySession()) {
            this.m_aRWLock.writeLocked(() -> {
                s_aLogger.error("The following " + this.m_aSessionScopes.size() + " session scopes are left over: " + this.m_aSessionScopes.toString());
                this.m_aSessionScopes.clear();
            });
        }
    }

    public void destroyAllSessions() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            if (!iSessionScope.selfDestruct().isContinue()) continue;
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    private void _endAllSessionScopes() {
        for (ISessionScope iSessionScope : this.getAllSessionScopes()) {
            this.onScopeEnd(iSessionScope);
        }
        this._checkIfAnySessionsExist();
    }

    public boolean isDestroyAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLocked(() -> this.m_bDestroyAllSessionsOnScopeEnd);
    }

    @Nonnull
    public EChange setDestroyAllSessionsOnScopeEnd(boolean bl) {
        return this.m_aRWLock.writeLocked(() -> {
            if (this.m_bDestroyAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bDestroyAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    public boolean isEndAllSessionsOnScopeEnd() {
        return this.m_aRWLock.readLocked(() -> this.m_bEndAllSessionsOnScopeEnd);
    }

    @Nonnull
    public EChange setEndAllSessionsOnScopeEnd(boolean bl) {
        return this.m_aRWLock.writeLocked(() -> {
            if (this.m_bEndAllSessionsOnScopeEnd == bl) {
                return EChange.UNCHANGED;
            }
            this.m_bEndAllSessionsOnScopeEnd = bl;
            return EChange.CHANGED;
        });
    }

    @Override
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    protected void onDestroy(@Nonnull IScope iScope) {
        if (this.isDestroyAllSessionsOnScopeEnd()) {
            this.destroyAllSessions();
        } else if (this.isEndAllSessionsOnScopeEnd()) {
            this._endAllSessionScopes();
        }
        s_aInstance = null;
    }

    private /* synthetic */ boolean lambda$onScopeEnd$553(String string, @Nonnull ISessionScope iSessionScope) {
        boolean bl = false;
        if (this.m_aSessionsInDestruction.add(string)) {
            ISessionScope iSessionScope2 = (ISessionScope)this.m_aSessionScopes.remove(string);
            if (iSessionScope2 != iSessionScope) {
                s_aLogger.error("Ending an unknown session with ID '" + string + "'");
                s_aLogger.error("  Scope to be removed: " + iSessionScope);
                s_aLogger.error("  Removed scope:       " + iSessionScope2);
            }
            bl = true;
        } else {
            s_aLogger.info("Already destructing session '" + string + "'");
        }
        return bl;
    }
}

