/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.state;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.state.EChange;
import com.helger.commons.state.IChangeIndicator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.wrapper.IWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ChangeWithValue<DATATYPE>
implements IChangeIndicator,
IWrapper<DATATYPE> {
    private final EChange m_eChange;
    private final DATATYPE m_aObj;

    public ChangeWithValue(@Nonnull IChangeIndicator iChangeIndicator, @Nullable DATATYPE DATATYPE) {
        ValueEnforcer.notNull(iChangeIndicator, "ChangeIndicator");
        this.m_eChange = EChange.valueOf(iChangeIndicator);
        this.m_aObj = DATATYPE;
    }

    @Override
    public boolean isChanged() {
        return this.m_eChange.isChanged();
    }

    @Override
    @Nullable
    public DATATYPE get() {
        return this.m_aObj;
    }

    @Nullable
    public DATATYPE getIfChanged(@Nullable DATATYPE DATATYPE) {
        return this.m_eChange.isChanged() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfChangedOrNull() {
        return this.getIfChanged(null);
    }

    @Nullable
    public DATATYPE getIfUnchanged(@Nullable DATATYPE DATATYPE) {
        return this.m_eChange.isUnchanged() ? this.m_aObj : DATATYPE;
    }

    @Nullable
    public DATATYPE getIfUnchangedOrNull() {
        return this.getIfUnchanged(null);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        ChangeWithValue changeWithValue = (ChangeWithValue)object;
        return this.m_eChange.equals(changeWithValue.m_eChange) && EqualsHelper.equals(this.m_aObj, changeWithValue.m_aObj);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append((Enum)this.m_eChange)).append(this.m_aObj).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("change", this.m_eChange).append("obj", this.m_aObj).toString();
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createChanged(@Nullable DATATYPE DATATYPE) {
        return new ChangeWithValue<DATATYPE>(EChange.CHANGED, DATATYPE);
    }

    @Nonnull
    public static <DATATYPE> ChangeWithValue<DATATYPE> createUnchanged(@Nullable DATATYPE DATATYPE) {
        return new ChangeWithValue<DATATYPE>(EChange.UNCHANGED, DATATYPE);
    }
}

