/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.withid;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsCollection;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.tree.withid.ITreeItemWithID;
import com.helger.commons.tree.withid.ITreeItemWithIDFactory;
import com.helger.commons.tree.withid.ITreeWithID;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>>
implements ITreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> {
    private final ITEMTYPE m_aRootItem;

    public BasicTreeWithID(@Nonnull ITreeItemWithIDFactory<KEYTYPE, DATATYPE, ITEMTYPE> iTreeItemWithIDFactory) {
        ValueEnforcer.notNull(iTreeItemWithIDFactory, "Factory");
        this.m_aRootItem = iTreeItemWithIDFactory.createRoot();
        if (this.m_aRootItem == null) {
            throw new IllegalStateException("Failed to create root item!");
        }
        if (this.m_aRootItem.getParent() != null) {
            throw new IllegalStateException("Create root item has a non-null parent!!!");
        }
    }

    @Override
    public final boolean hasChildren() {
        return true;
    }

    @Override
    @Nonnegative
    public int getChildCount() {
        return 1;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsCollection<? extends ITEMTYPE> getAllChildren() {
        return new CommonsArrayList<ITEMTYPE>(this.m_aRootItem);
    }

    @Override
    @Nonnull
    public final ITEMTYPE getRootItem() {
        return this.m_aRootItem;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        BasicTreeWithID basicTreeWithID = (BasicTreeWithID)object;
        return this.m_aRootItem.equals(basicTreeWithID.m_aRootItem);
    }

    public int hashCode() {
        return new HashCodeGenerator(this).append(this.m_aRootItem).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(this).append("root", this.m_aRootItem).toString();
    }
}

