/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.tree.xml;

import com.helger.commons.collection.impl.NonBlockingStack;
import com.helger.commons.hierarchy.ChildrenProviderHasChildrenSorting;
import com.helger.commons.hierarchy.visit.DefaultHierarchyVisitorCallback;
import com.helger.commons.hierarchy.visit.EHierarchyVisitorReturn;
import com.helger.commons.id.IHasID;
import com.helger.commons.microdom.IMicroDocument;
import com.helger.commons.microdom.IMicroElement;
import com.helger.commons.microdom.MicroElement;
import com.helger.commons.microdom.util.ChildrenProviderElementWithName;
import com.helger.commons.microdom.util.MicroVisitor;
import com.helger.commons.tree.IBasicTree;
import com.helger.commons.tree.IBasicTreeItem;
import com.helger.commons.tree.ITreeItem;
import com.helger.commons.tree.util.TreeVisitor;
import com.helger.commons.tree.withid.BasicTreeWithID;
import com.helger.commons.tree.withid.DefaultTreeWithID;
import com.helger.commons.tree.withid.ITreeItemWithID;
import com.helger.commons.tree.withid.unique.DefaultTreeWithGlobalUniqueID;
import com.helger.commons.tree.xml.IConverterMicroNodeToTreeItem;
import com.helger.commons.tree.xml.IConverterTreeItemToMicroNode;
import java.util.Comparator;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TreeXMLConverter {
    public static final String ELEMENT_ROOT = "root";
    public static final String ELEMENT_ITEM = "item";
    public static final String ATTR_ID = "id";
    public static final String ELEMENT_DATA = "data";
    private static final TreeXMLConverter s_aInstance = new TreeXMLConverter();

    private TreeXMLConverter() {
    }

    @Nonnull
    public static <DATATYPE, ITEMTYPE extends ITreeItemWithID<String, DATATYPE, ITEMTYPE>> IMicroElement getTreeWithStringIDAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        return TreeXMLConverter.getTreeWithIDAsXML(iBasicTree, IHasID.getComparatorID(), string -> string, iConverterTreeItemToMicroNode);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> IMicroElement getTreeWithIDAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super ITEMTYPE> comparator, final @Nonnull Function<KEYTYPE, String> function, final @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        MicroElement microElement = new MicroElement(ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> nonBlockingStack = new NonBlockingStack<MicroElement>();
        nonBlockingStack.push(microElement);
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(comparator), new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).appendElement(TreeXMLConverter.ELEMENT_ITEM);
                    iMicroElement.setAttribute(TreeXMLConverter.ATTR_ID, (String)function.apply(ITEMTYPE.getID()));
                    IMicroElement iMicroElement2 = iMicroElement.appendElement(TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push(iMicroElement);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return microElement;
    }

    @Nonnull
    public static <DATATYPE, ITEMTYPE extends ITreeItem<DATATYPE, ITEMTYPE>> IMicroElement getTreeAsXML(@Nonnull IBasicTree<DATATYPE, ITEMTYPE> iBasicTree, @Nonnull Comparator<? super ITEMTYPE> comparator, final @Nonnull IConverterTreeItemToMicroNode<? super DATATYPE> iConverterTreeItemToMicroNode) {
        final String string = iConverterTreeItemToMicroNode.getNamespaceURI();
        MicroElement microElement = new MicroElement(string, ELEMENT_ROOT);
        final NonBlockingStack<MicroElement> nonBlockingStack = new NonBlockingStack<MicroElement>();
        nonBlockingStack.push(microElement);
        TreeVisitor.visitTree(iBasicTree, new ChildrenProviderHasChildrenSorting<ITEMTYPE>(comparator), new DefaultHierarchyVisitorCallback<ITEMTYPE>(){

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    IMicroElement iMicroElement = ((IMicroElement)nonBlockingStack.peek()).appendElement(string, TreeXMLConverter.ELEMENT_ITEM);
                    IMicroElement iMicroElement2 = iMicroElement.appendElement(string, TreeXMLConverter.ELEMENT_DATA);
                    iConverterTreeItemToMicroNode.appendDataValue(iMicroElement2, ITEMTYPE.getData());
                    nonBlockingStack.push(iMicroElement);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemAfterChildren(@Nullable ITEMTYPE ITEMTYPE) {
                if (ITEMTYPE != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
        return microElement;
    }

    private static <KEYTYPE, DATATYPE, ITEMTYPE extends ITreeItemWithID<KEYTYPE, DATATYPE, ITEMTYPE>> void _getXMLAsTreeWithID(@Nonnull IMicroElement iMicroElement, final @Nonnull Function<String, KEYTYPE> function, final @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem, @Nonnull BasicTreeWithID<KEYTYPE, DATATYPE, ITEMTYPE> basicTreeWithID) {
        final String string = iConverterMicroNodeToTreeItem.getNamespaceURI();
        final NonBlockingStack<IBasicTreeItem> nonBlockingStack = new NonBlockingStack<IBasicTreeItem>();
        nonBlockingStack.push(basicTreeWithID.getRootItem());
        MicroVisitor.visit(iMicroElement, new ChildrenProviderElementWithName(string, ELEMENT_ITEM), new DefaultHierarchyVisitorCallback<IMicroElement>(){

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemBeforeChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    Object r = function.apply(iMicroElement.getAttributeValue(TreeXMLConverter.ATTR_ID));
                    IMicroElement iMicroElement2 = iMicroElement.getFirstChildElement(string, TreeXMLConverter.ELEMENT_DATA);
                    Object DATATYPE = iConverterMicroNodeToTreeItem.getAsDataValue(iMicroElement2);
                    Object ITEMTYPE = ((ITreeItemWithID)nonBlockingStack.peek()).createChildItem(r, DATATYPE);
                    nonBlockingStack.push(ITEMTYPE);
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }

            @Override
            @Nonnull
            public EHierarchyVisitorReturn onItemAfterChildren(@Nullable IMicroElement iMicroElement) {
                if (iMicroElement != null) {
                    nonBlockingStack.pop();
                }
                return EHierarchyVisitorReturn.CONTINUE;
            }
        });
    }

    @Nonnull
    public static <DATATYPE> DefaultTreeWithGlobalUniqueID<String, DATATYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroDocument iMicroDocument, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueStringID(iMicroDocument.getDocumentElement(), iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <DATATYPE> DefaultTreeWithGlobalUniqueID<String, DATATYPE> getXMLAsTreeWithUniqueStringID(@Nonnull IMicroElement iMicroElement, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(iMicroElement, (String string) -> string, iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, DATATYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroDocument iMicroDocument, @Nonnull Function<String, KEYTYPE> function, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithUniqueID(iMicroDocument.getDocumentElement(), function, iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithGlobalUniqueID<KEYTYPE, DATATYPE> getXMLAsTreeWithUniqueID(@Nonnull IMicroElement iMicroElement, @Nonnull Function<String, KEYTYPE> function, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithGlobalUniqueID defaultTreeWithGlobalUniqueID = new DefaultTreeWithGlobalUniqueID();
        TreeXMLConverter._getXMLAsTreeWithID(iMicroElement, function, iConverterMicroNodeToTreeItem, defaultTreeWithGlobalUniqueID);
        return defaultTreeWithGlobalUniqueID;
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithID<KEYTYPE, DATATYPE> getXMLAsTreeWithID(@Nonnull IMicroDocument iMicroDocument, @Nonnull Function<String, KEYTYPE> function, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        return TreeXMLConverter.getXMLAsTreeWithID(iMicroDocument.getDocumentElement(), function, iConverterMicroNodeToTreeItem);
    }

    @Nonnull
    public static <KEYTYPE, DATATYPE> DefaultTreeWithID<KEYTYPE, DATATYPE> getXMLAsTreeWithID(@Nonnull IMicroElement iMicroElement, @Nonnull Function<String, KEYTYPE> function, @Nonnull IConverterMicroNodeToTreeItem<? extends DATATYPE> iConverterMicroNodeToTreeItem) {
        DefaultTreeWithID defaultTreeWithID = new DefaultTreeWithID();
        TreeXMLConverter._getXMLAsTreeWithID(iMicroElement, function, iConverterMicroNodeToTreeItem, defaultTreeWithID);
        return defaultTreeWithID;
    }
}

