/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.string.StringParser;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class DateTimeTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, String.class, calendar -> Long.toString(calendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Long.class, calendar -> calendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(Calendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, String.class, gregorianCalendar -> Long.toString(gregorianCalendar.getTimeInMillis()));
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Long.class, gregorianCalendar -> gregorianCalendar.getTimeInMillis());
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Date.class, Calendar::getTime);
        iTypeConverterRegistry.registerTypeConverter(GregorianCalendar.class, Instant.class, Calendar::toInstant);
        iTypeConverterRegistry.registerTypeConverter(String.class, GregorianCalendar.class, string -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(StringParser.parseLong(string, 0L));
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, GregorianCalendar.class, number -> {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(number.longValue());
            return gregorianCalendar;
        });
        iTypeConverterRegistry.registerTypeConverter(OffsetDateTime.class, GregorianCalendar.class, offsetDateTime -> GregorianCalendar.from(offsetDateTime.toZonedDateTime()));
        iTypeConverterRegistry.registerTypeConverter(ZonedDateTime.class, GregorianCalendar.class, GregorianCalendar::from);
        iTypeConverterRegistry.registerTypeConverter(Date.class, Calendar.class, date -> {
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)date);
            return calendar;
        });
        iTypeConverterRegistry.registerTypeConverter(Date.class, String.class, date -> Long.toString(date.getTime()));
        iTypeConverterRegistry.registerTypeConverter(Date.class, Long.class, date -> date.getTime());
        iTypeConverterRegistry.registerTypeConverter(String.class, Date.class, string -> new Date(StringParser.parseLong(string, 0L)));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(Date.class, Date::toInstant);
        iTypeConverterRegistry.registerTypeConverterRuleAssignableSourceFixedDestination(Number.class, Date.class, number -> new Date(number.longValue()));
    }
}

