/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert;

import com.helger.commons.annotation.IsSPIImplementation;
import com.helger.commons.mutable.MutableBigDecimal;
import com.helger.commons.mutable.MutableBigInteger;
import com.helger.commons.mutable.MutableBoolean;
import com.helger.commons.mutable.MutableByte;
import com.helger.commons.mutable.MutableChar;
import com.helger.commons.mutable.MutableDouble;
import com.helger.commons.mutable.MutableFloat;
import com.helger.commons.mutable.MutableInt;
import com.helger.commons.mutable.MutableLong;
import com.helger.commons.mutable.MutableShort;
import com.helger.commons.typeconvert.ITypeConverterRegistrarSPI;
import com.helger.commons.typeconvert.ITypeConverterRegistry;
import com.helger.commons.typeconvert.TypeConverter;
import java.math.BigDecimal;
import java.math.BigInteger;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@Immutable
@IsSPIImplementation
public final class MutableTypeConverterRegistrar
implements ITypeConverterRegistrarSPI {
    @Override
    public void registerTypeConverter(@Nonnull ITypeConverterRegistry iTypeConverterRegistry) {
        iTypeConverterRegistry.registerTypeConverter(MutableBigDecimal.class, BigDecimal.class, mutableBigDecimal -> mutableBigDecimal.getAsBigDecimal());
        iTypeConverterRegistry.registerTypeConverter(BigDecimal.class, MutableBigDecimal.class, bigDecimal -> new MutableBigDecimal((BigDecimal)bigDecimal));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableBigDecimal.class, mutableBigDecimal -> mutableBigDecimal.getAsBigDecimal());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableBigDecimal.class, object -> new MutableBigDecimal(TypeConverter.convertIfNecessary(object, BigDecimal.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableBigInteger.class, BigInteger.class, mutableBigInteger -> mutableBigInteger.getAsBigInteger());
        iTypeConverterRegistry.registerTypeConverter(BigInteger.class, MutableBigInteger.class, bigInteger -> new MutableBigInteger((BigInteger)bigInteger));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableBigInteger.class, mutableBigInteger -> mutableBigInteger.getAsBigInteger());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableBigInteger.class, object -> new MutableBigInteger(TypeConverter.convertIfNecessary(object, BigInteger.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableBoolean.class, Boolean.class, mutableBoolean -> mutableBoolean.getAsBoolean());
        iTypeConverterRegistry.registerTypeConverter(Boolean.class, MutableBoolean.class, bl -> new MutableBoolean((Boolean)bl));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableBoolean.class, mutableBoolean -> mutableBoolean.getAsBoolean());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableBoolean.class, object -> new MutableBoolean(TypeConverter.convertIfNecessary(object, Boolean.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableByte.class, Byte.class, mutableByte -> mutableByte.getAsByte());
        iTypeConverterRegistry.registerTypeConverter(Byte.class, MutableByte.class, by -> new MutableByte((Number)by));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableByte.class, mutableByte -> mutableByte.getAsByte());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableByte.class, object -> new MutableByte(TypeConverter.convertIfNecessary(object, Byte.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableChar.class, Character.class, mutableChar -> mutableChar.getAsCharacter());
        iTypeConverterRegistry.registerTypeConverter(Character.class, MutableChar.class, c -> new MutableChar((Character)c));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableChar.class, mutableChar -> mutableChar.getAsCharacter());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableChar.class, object -> new MutableChar(TypeConverter.convertIfNecessary(object, Character.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableDouble.class, Double.class, mutableDouble -> mutableDouble.getAsDouble());
        iTypeConverterRegistry.registerTypeConverter(Double.class, MutableDouble.class, d -> new MutableDouble((Number)d));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableDouble.class, mutableDouble -> mutableDouble.getAsDouble());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableDouble.class, object -> new MutableDouble(TypeConverter.convertIfNecessary(object, Double.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableFloat.class, Float.class, mutableFloat -> mutableFloat.getAsFloat());
        iTypeConverterRegistry.registerTypeConverter(Float.class, MutableFloat.class, f -> new MutableFloat((Number)f));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableFloat.class, mutableFloat -> mutableFloat.getAsFloat());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableFloat.class, object -> new MutableFloat(TypeConverter.convertIfNecessary(object, Float.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableInt.class, Integer.class, mutableInt -> mutableInt.getAsInteger());
        iTypeConverterRegistry.registerTypeConverter(Integer.class, MutableInt.class, n -> new MutableInt((Number)n));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableInt.class, mutableInt -> mutableInt.getAsInteger());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableInt.class, object -> new MutableInt(TypeConverter.convertIfNecessary(object, Integer.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableLong.class, Long.class, mutableLong -> mutableLong.getAsLong());
        iTypeConverterRegistry.registerTypeConverter(Long.class, MutableLong.class, l -> new MutableLong((Number)l));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableLong.class, mutableLong -> mutableLong.getAsLong());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableLong.class, object -> new MutableLong(TypeConverter.convertIfNecessary(object, Long.class)));
        iTypeConverterRegistry.registerTypeConverter(MutableShort.class, Short.class, mutableShort -> mutableShort.getAsShort());
        iTypeConverterRegistry.registerTypeConverter(Short.class, MutableShort.class, s -> new MutableShort((Number)s));
        iTypeConverterRegistry.registerTypeConverterRuleFixedSourceAnyDestination(MutableShort.class, mutableShort -> mutableShort.getAsShort());
        iTypeConverterRegistry.registerTypeConverterRuleAnySourceFixedDestination(MutableShort.class, object -> new MutableShort(TypeConverter.convertIfNecessary(object, Short.class)));
    }
}

