/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.typeconvert.rule;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.typeconvert.ITypeConverterRule;
import com.helger.commons.typeconvert.rule.AbstractTypeConverterRule;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TypeConverterRuleFixedSourceAssignableDestination<SRC, DST>
extends AbstractTypeConverterRule<SRC, DST> {
    private final Class<SRC> m_aSrcClass;
    private final Class<DST> m_aDstClass;
    private final Function<SRC, DST> m_aConverter;

    public TypeConverterRuleFixedSourceAssignableDestination(@Nonnull Class<SRC> clazz, @Nonnull Class<DST> clazz2, @Nonnull Function<SRC, DST> function) {
        super(ITypeConverterRule.ESubType.FIXED_SRC_ASSIGNABLE_DST);
        this.m_aSrcClass = ValueEnforcer.notNull(clazz, "SrcClass");
        this.m_aDstClass = ValueEnforcer.notNull(clazz2, "DestClass");
        this.m_aConverter = ValueEnforcer.notNull(function, "Converter");
    }

    @Override
    public final boolean canConvert(@Nonnull Class<?> clazz, @Nonnull Class<?> clazz2) {
        return this.m_aSrcClass.equals(clazz) && this.m_aDstClass.isAssignableFrom(clazz2);
    }

    @Nonnull
    public final Class<SRC> getSourceClass() {
        return this.m_aSrcClass;
    }

    @Nonnull
    public final Class<DST> getDestinationClass() {
        return this.m_aDstClass;
    }

    @Override
    @Nullable
    public DST apply(@Nonnull SRC SRC) {
        return this.m_aConverter.apply(SRC);
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("srcClass", this.m_aSrcClass.getName()).append("dstClass", this.m_aDstClass.getName()).append("converter", this.m_aConverter).toString();
    }
}

