/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.url.IURLProtocol;
import com.helger.commons.url.URLProtocolRegistry;
import java.io.Serializable;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public interface IURLData
extends Serializable {
    @Nullable
    default public IURLProtocol getProtocol() {
        return URLProtocolRegistry.getInstance().getProtocol(this.getPath());
    }

    default public boolean hasKnownProtocol() {
        return URLProtocolRegistry.getInstance().hasKnownProtocol(this.getPath());
    }

    @Nonnull
    public String getPath();

    public boolean hasParams();

    @Nonnegative
    public int getParamCount();

    @Nullable
    @ReturnsMutableObject(value="design")
    public ICommonsOrderedMap<String, String> directGetAllParams();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsOrderedMap<String, String> getAllParams();

    public boolean hasAnchor();

    @Nullable
    public String getAnchor();
}

