/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.annotation.DevelopersNote;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.typeconvert.TypeConverter;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SMap
extends CommonsLinkedHashMap<String, String> {
    public SMap() {
    }

    public SMap(@Nullable Map<String, String> map) {
        if (map != null) {
            super.putAll(map);
        }
    }

    public SMap(@Nonnull String string, @Nonnull String string2) {
        this.add(string, string2);
    }

    public SMap(@Nonnull String string, @Nonnull int n) {
        this.add(string, n);
    }

    @Override
    @Deprecated
    @DevelopersNote(value="Use add instead - only for API compliance!")
    public String put(@Nonnull String string, @Nonnull String string2) {
        return super.put(string, string2);
    }

    @Override
    @Deprecated
    @DevelopersNote(value="Use add instead - only for API compliance!")
    public void putAll(Map<? extends String, ? extends String> map) {
        super.putAll(map);
    }

    @Nonnull
    public SMap addIfNotNull(@Nonnull String string, @Nonnull Object object) {
        return this.addIfNotNull(string, TypeConverter.convertIfNecessary(object, String.class));
    }

    @Nonnull
    public SMap addIfNotNull(@Nonnull String string, @Nullable String string2) {
        super.putIfNotNull(string, string2);
        return this;
    }

    @Nonnull
    public SMap addIf(@Nonnull String string, @Nullable String string2, @Nonnull Predicate<String> predicate) {
        super.putIf(string, string2, predicate);
        return this;
    }

    @Nonnull
    public SMap add(@Nonnull String string, @Nonnull Object object) {
        return this.add(string, TypeConverter.convertIfNecessary(object, String.class));
    }

    @Nonnull
    public SMap add(@Nonnull String string, @Nonnull String string2) {
        super.put(string, string2);
        return this;
    }

    @Nonnull
    public SMap add(@Nonnull String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    public SMap add(@Nonnull String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public SMap add(@Nonnull String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public SMap addWithoutValue(@Nonnull String string) {
        return this.add(string, "");
    }

    @Override
    @Nonnull
    public SMap getClone() {
        return new SMap(this);
    }
}

