/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.url;

import com.helger.commons.ValueEnforcer;
import com.helger.commons.annotation.Nonempty;
import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.annotation.ReturnsMutableObject;
import com.helger.commons.collection.CollectionHelper;
import com.helger.commons.collection.ext.CommonsLinkedHashMap;
import com.helger.commons.collection.ext.ICommonsOrderedMap;
import com.helger.commons.equals.EqualsHelper;
import com.helger.commons.hashcode.HashCodeGenerator;
import com.helger.commons.lang.ICloneable;
import com.helger.commons.string.StringHelper;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.url.ISimpleURL;
import com.helger.commons.url.IURLData;
import com.helger.commons.url.URLData;
import com.helger.commons.url.URLHelper;
import com.helger.commons.url.URLParameterDecoder;
import java.math.BigInteger;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class SimpleURL
implements ISimpleURL,
ICloneable<SimpleURL> {
    private final String m_sPath;
    private ICommonsOrderedMap<String, String> m_aParams;
    private String m_sAnchor;

    public SimpleURL() {
        this(URLData.EMPTY_URL_DATA);
    }

    public SimpleURL(@Nonnull URL uRL) {
        this(uRL, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull URL uRL, @Nonnull Charset charset) {
        this(uRL.toExternalForm(), charset);
    }

    public SimpleURL(@Nonnull String string) {
        this(string, URLHelper.CHARSET_URL_OBJ);
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset) {
        this(URLHelper.getAsURLData(string, new URLParameterDecoder(charset)));
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map) {
        this(string);
        if (CollectionHelper.isNotEmpty(map)) {
            if (this.m_aParams == null) {
                this.m_aParams = new CommonsLinkedHashMap<String, String>();
            }
            this.m_aParams.putAll(map);
        }
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Map<String, String> map) {
        this(string, charset);
        if (CollectionHelper.isNotEmpty(map)) {
            if (this.m_aParams == null) {
                this.m_aParams = new CommonsLinkedHashMap<String, String>();
            }
            this.m_aParams.putAll(map);
        }
    }

    public SimpleURL(@Nonnull String string, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, map);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull String string, @Nonnull Charset charset, @Nullable Map<String, String> map, @Nullable String string2) {
        this(string, charset, map);
        this.m_sAnchor = string2;
    }

    public SimpleURL(@Nonnull IURLData iURLData) {
        ValueEnforcer.notNull(iURLData, "URL");
        this.m_sPath = iURLData.getPath();
        if (iURLData.hasParams()) {
            this.m_aParams = iURLData.getAllParams();
        }
        this.m_sAnchor = iURLData.getAnchor();
    }

    @Override
    @Nonnull
    public final String getPath() {
        return this.m_sPath;
    }

    @Override
    public final boolean hasParams() {
        return CollectionHelper.isNotEmpty(this.m_aParams);
    }

    @Override
    @Nonnegative
    public final int getParamCount() {
        return CollectionHelper.getSize(this.m_aParams);
    }

    @Override
    @Nullable
    public final String getParam(@Nullable String string) {
        return this.m_aParams == null ? null : (String)this.m_aParams.get(string);
    }

    @Override
    @Nonnull
    @ReturnsMutableObject(value="design")
    public final ICommonsOrderedMap<String, String> directGetAllParams() {
        return this.m_aParams;
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public final ICommonsOrderedMap<String, String> getAllParams() {
        return CollectionHelper.newOrderedMap(this.m_aParams);
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string) {
        return this.add(string, "");
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, @Nonnull String string2) {
        ValueEnforcer.notEmpty(string, "Key");
        ValueEnforcer.notNull(string2, "Value");
        if (this.m_aParams == null) {
            this.m_aParams = new CommonsLinkedHashMap<String, String>();
        }
        this.m_aParams.put(string, string2);
        return this;
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, boolean bl) {
        return this.add(string, Boolean.toString(bl));
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, int n) {
        return this.add(string, Integer.toString(n));
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, long l) {
        return this.add(string, Long.toString(l));
    }

    @Nonnull
    public SimpleURL add(@Nonnull @Nonempty String string, @Nonnull BigInteger bigInteger) {
        return this.add(string, bigInteger.toString());
    }

    @Nonnull
    public SimpleURL addIfNonNull(@Nonnull @Nonempty String string, @Nullable String string2) {
        if (string2 != null) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addIf(@Nonnull @Nonempty String string, @Nullable String string2, @Nonnull Predicate<String> predicate) {
        if (predicate.test(string2)) {
            this.add(string, string2);
        }
        return this;
    }

    @Nonnull
    public SimpleURL addAll(@Nullable Map<String, String> map) {
        if (CollectionHelper.isNotEmpty(map)) {
            if (this.m_aParams == null) {
                this.m_aParams = new CommonsLinkedHashMap<String, String>();
            }
            this.m_aParams.putAll(map);
        }
        return this;
    }

    @Nonnull
    public SimpleURL remove(@Nullable String string) {
        if (this.m_aParams != null) {
            this.m_aParams.remove(string);
        }
        return this;
    }

    @Override
    public final boolean hasAnchor() {
        return StringHelper.hasText(this.m_sAnchor);
    }

    @Override
    @Nullable
    public final String getAnchor() {
        return this.m_sAnchor;
    }

    @Nonnull
    public SimpleURL setAnchor(@Nullable String string) {
        this.m_sAnchor = string;
        return this;
    }

    @Override
    @Nonnull
    public SimpleURL getClone() {
        return new SimpleURL(this);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !this.getClass().equals(object.getClass())) {
            return false;
        }
        SimpleURL simpleURL = (SimpleURL)object;
        return this.m_sPath.equals(simpleURL.m_sPath) && EqualsHelper.equals(this.m_aParams, simpleURL.m_aParams) && EqualsHelper.equals(this.m_sAnchor, simpleURL.m_sAnchor);
    }

    public int hashCode() {
        return ((HashCodeGenerator)new HashCodeGenerator(this).append(this.m_sPath).append(this.m_aParams)).append(this.m_sAnchor).getHashCode();
    }

    public String toString() {
        return new ToStringGenerator(null).append("path", this.m_sPath).appendIfNotNull("params", this.m_aParams).appendIfNotNull("anchor", this.m_sAnchor).toString();
    }
}

