/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml;

import com.helger.commons.system.SystemProperties;
import com.helger.commons.xml.XMLFactory;
import com.helger.commons.xml.serialize.read.DOMReader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class XMLSystemProperties {
    public static final String SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT = "jdx.xml.entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT = "entityExpansionLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT = "jdx.xml.elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT = "elementAttributeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR = "jdx.xml.maxOccur";
    public static final String SYSTEM_PROPERTY_MAX_OCCUR = "maxOccur";
    public static final String SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT = "jdx.xml.totalEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT = "jdx.xml.maxGeneralEntitySizeLimit";
    public static final String SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT = "jdx.xml.maxParameterEntitySizeLimit";
    private static final Logger s_aLogger = LoggerFactory.getLogger(XMLSystemProperties.class);
    private static final XMLSystemProperties s_aInstance = new XMLSystemProperties();

    private XMLSystemProperties() {
    }

    private static void _onSystemPropertyChange() {
        XMLFactory.reinitialize();
        DOMReader.reinitialize();
        s_aLogger.info("XML processing system properties changed!");
    }

    public static void setXMLEntityExpansionLimit(int n) {
        XMLSystemProperties.setXMLEntityExpansionLimit(Integer.toString(n));
    }

    public static void setXMLEntityExpansionLimit(@Nullable String string) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT, string);
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT, string);
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLEntityExpansionLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_ENTITY_EXPANSION_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_ENTITY_EXPANSION_LIMIT);
        }
        if (string == null) {
            return 64000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLElementAttributeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT, Integer.toString(n));
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT, Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLElementAttributeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_ELEMENT_ATTRIBUTE_LIMIT);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_ELEMENT_ATTRIBUTE_LIMIT);
        }
        if (string == null) {
            return 10000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxOccur(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_MAX_OCCUR, Integer.toString(n));
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR, Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxOccur() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_OCCUR);
        if (string == null) {
            string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_MAX_OCCUR);
        }
        if (string == null) {
            return 5000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLTotalEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT, Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLTotalEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_TOTAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 500000000;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxGeneralEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT, Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxGeneralEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_GENERAL_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }

    public static void setXMLMaxParameterEntitySizeLimit(int n) {
        SystemProperties.setPropertyValue(SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT, Integer.toString(n));
        XMLSystemProperties._onSystemPropertyChange();
    }

    public static int getXMLMaxParameterEntitySizeLimit() {
        String string = SystemProperties.getPropertyValueOrNull(SYSTEM_PROPERTY_JDX_XML_MAX_PARAMETER_ENTITY_SIZE_LIMIT);
        if (string == null) {
            return 0;
        }
        return Integer.parseInt(string);
    }
}

