/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.ls;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.collection.ext.CommonsArrayList;
import com.helger.commons.collection.ext.ICommonsList;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.xml.ls.AbstractLSResourceResolver;
import com.helger.commons.xml.ls.LSResourceData;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.ls.LSInput;

@ThreadSafe
public class CollectingLSResourceResolver
extends AbstractLSResourceResolver {
    private static final Logger s_aLogger = LoggerFactory.getLogger(CollectingLSResourceResolver.class);
    private final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ICommonsList<LSResourceData> m_aList = new CommonsArrayList<LSResourceData>();

    @Nonnull
    @ReturnsMutableCopy
    public ICommonsList<LSResourceData> getAllRequestedResources() {
        return this.m_aRWLock.readLocked(() -> (ICommonsList)this.m_aList.getClone());
    }

    @Override
    @Nullable
    public LSInput mainResolveResource(@Nullable String string, @Nullable String string2, @Nullable String string3, @Nullable String string4, @Nullable String string5) {
        LSResourceData lSResourceData = new LSResourceData(string, string2, string3, string4, string5);
        this.m_aRWLock.writeLocked(() -> this.m_aList.add(lSResourceData));
        return null;
    }
}

