/*
 * Decompiled with CFR 0.152.
 */
package com.helger.commons.xml.sax;

import com.helger.commons.annotation.ReturnsMutableCopy;
import com.helger.commons.concurrent.SimpleReadWriteLock;
import com.helger.commons.error.IErrorLevel;
import com.helger.commons.error.IHasResourceErrorGroup;
import com.helger.commons.error.IResourceErrorGroup;
import com.helger.commons.error.ResourceErrorGroup;
import com.helger.commons.state.EChange;
import com.helger.commons.string.ToStringGenerator;
import com.helger.commons.xml.sax.AbstractSAXErrorHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

@ThreadSafe
public class CollectingSAXErrorHandler
extends AbstractSAXErrorHandler
implements IHasResourceErrorGroup {
    protected final SimpleReadWriteLock m_aRWLock = new SimpleReadWriteLock();
    @GuardedBy(value="m_aRWLock")
    private final ResourceErrorGroup m_aErrors = new ResourceErrorGroup();

    public CollectingSAXErrorHandler() {
    }

    public CollectingSAXErrorHandler(@Nullable ErrorHandler errorHandler) {
        super(errorHandler);
    }

    @Override
    protected void internalLog(@Nonnull IErrorLevel iErrorLevel, SAXParseException sAXParseException) {
        this.m_aRWLock.writeLocked(() -> this.m_aErrors.addResourceError(CollectingSAXErrorHandler.getSaxParseError(iErrorLevel, sAXParseException)));
    }

    @Override
    @Nonnull
    @ReturnsMutableCopy
    public IResourceErrorGroup getResourceErrors() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.getClone());
    }

    public boolean containsAtLeastOneError() {
        return this.m_aRWLock.readLocked(() -> this.m_aErrors.containsAtLeastOneError());
    }

    @Nonnull
    public EChange clearResourceErrors() {
        return this.m_aRWLock.writeLocked(() -> this.m_aErrors.clear());
    }

    @Override
    public String toString() {
        return ToStringGenerator.getDerived(super.toString()).append("errors", this.m_aErrors).toString();
    }
}

